/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network.handlers;

import org.eclipse.tml.protocol.lib.IMessageHandler;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.VNCProtocolData;
import org.eclipse.tml.vncviewer.registry.VNCProtocolRegistry;

public class FramebufferUpdateHandler
implements IMessageHandler {
    public ProtocolMessage handleMessage(ProtocolHandle handle, ProtocolMessage message) {
        VNCProtocolData protocolData = VNCProtocolRegistry.getInstance().get(handle);
        if (protocolData != null) {
            IVNCPainter painter = protocolData.getVncPainter();
            int minX = painter.getWidth();
            int minY = painter.getHeight();
            int maxX = 0;
            int maxY = 0;
            int numRect = (Integer)message.getFieldValue("numberOfRectangles");
            int rect = 0;
            while (rect < numRect) {
                int rectX1 = (Integer)message.getFieldValue("x-position", "rectangle", rect);
                int rectY1 = (Integer)message.getFieldValue("y-position", "rectangle", rect);
                int rectX2 = rectX1 + (Integer)message.getFieldValue("width", "rectangle", rect);
                int rectY2 = rectY1 + (Integer)message.getFieldValue("height", "rectangle", rect);
                minX = Math.min(minX, rectX1);
                minY = Math.min(minY, rectY1);
                maxX = Math.max(maxX, rectX2);
                maxY = Math.max(maxY, rectY2);
                ++rect;
            }
            painter.updateRectangle(minX, minY, maxX, maxY);
        }
        return null;
    }
}

