/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.utilities.logger;

import org.eclipse.tml.utilities.logger.ILogger;
import org.eclipse.tml.utilities.logger.SimpleLogger;

public abstract class LoggerFactory {
    public static final ILogger getFactory(int log) {
        SimpleLogger logger = SimpleLogger.getInstance();
        return logger;
    }

    public static final ILogger getLogger(int log, Class _class) {
        LoggerFactory.getFactory(log).configureLogger(_class);
        return LoggerFactory.getFactory(log);
    }

    public static final ILogger getLogger(int log, Class _class, int logOutput, String logMinLevel, String logFileName) {
        if (logFileName == null) {
            logFileName = "default.log";
        }
        switch (logOutput) {
            case 1: {
                LoggerFactory.getFactory(log).setLogToConsole();
                break;
            }
            case 2: {
                LoggerFactory.getFactory(log).setLogToFile(logFileName);
                break;
            }
            case 3: {
                LoggerFactory.getFactory(log).setLogToHTMLFile(logFileName);
                break;
            }
            default: {
                LoggerFactory.getFactory(log).setLogToConsole();
            }
        }
        LoggerFactory.getFactory(log).configureLogger(_class);
        if (logMinLevel != null) {
            LoggerFactory.getFactory(log).setLevel(logMinLevel);
        }
        return LoggerFactory.getFactory(log);
    }
}

