/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.AbstractCrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.CrossReferenceIndexHandler;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.StopParsing;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class OnDemandCrossReferenceIndex
extends AbstractCrossReferenceIndex {
    private static final ThreadGroup threadGroup = new ThreadGroup("XRefIndex");
    private static final AtomicInteger threadCounter = new AtomicInteger();
    private static final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), OnDemandCrossReferenceIndex::createThread));
    private final Set<String> modelResourceFileExtensions;

    public OnDemandCrossReferenceIndex(ResourceSet resourceSet) {
        this(InternalIndexUtil.getSemanticModelFileExtensions(resourceSet));
    }

    public OnDemandCrossReferenceIndex(Set<String> resourceFileExtensions) {
        this.modelResourceFileExtensions = resourceFileExtensions;
    }

    private static Thread createThread(Runnable run) {
        Thread result = new Thread(threadGroup, run, "XRefIndex-" + threadCounter.incrementAndGet());
        result.setDaemon(true);
        return result;
    }

    @Override
    boolean isShard0(URI uriWithoutExtension) {
        if (!this.shards.containsKey((Object)uriWithoutExtension) || !OnDemandCrossReferenceIndex.intersects(this.shards.get((Object)uriWithoutExtension), this.modelResourceFileExtensions)) {
            this.index(uriWithoutExtension.appendFileExtension("uml"));
        }
        return super.isShard0(uriWithoutExtension);
    }

    private static <T> boolean intersects(Set<? extends T> a, Set<? extends T> b) {
        return !a.isEmpty() && !b.isEmpty() && a.stream().anyMatch(b::contains);
    }

    @Override
    Callable<SetMultimap<URI, URI>> getSubunitsCallable() {
        return () -> ImmutableSetMultimap.of();
    }

    @Override
    Callable<SetMultimap<URI, URI>> getOutgoingCrossReferencesCallable() {
        return () -> ImmutableSetMultimap.of();
    }

    @Override
    Callable<SetMultimap<URI, URI>> getIncomingCrossReferencesCallable() {
        return () -> ImmutableSetMultimap.of();
    }

    @Override
    <V> ListenableFuture<V> afterIndex(Callable<V> callable) {
        return executor.submit(callable);
    }

    @Override
    <V> V ifAvailable(Callable<V> callable, Callable<? extends V> elseCallable) throws CoreException {
        return this.sync(this.afterIndex(callable));
    }

    void index(URI resourceURI) {
        LinkedList toIndex = Lists.newLinkedList();
        toIndex.offer(resourceURI);
        URI next = (URI)toIndex.poll();
        while (next != null) {
            this.doIndex(next);
            this.subunitToParents.get((Object)next).stream().filter(((Predicate<URI>)arg_0 -> ((SetMultimap)this.shards).containsKey(arg_0)).negate()).forEach(toIndex::offer);
            next = (URI)toIndex.poll();
        }
    }

    private void doIndex(URI resourceURI) {
        CrossReferenceIndexHandler handler = new CrossReferenceIndexHandler(resourceURI, true);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream input = URIConverter.INSTANCE.createInputStream(resourceURI);){
                InputSource source = new InputSource(input);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                SAXParser parser = factory.newSAXParser();
                parser.parse(source, (DefaultHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StopParsing stopParsing) {
        }
        catch (Exception e) {
            Activator.log.error("Failed to scan model resource for parent reference.", (Throwable)e);
        }
        this.aggregateSubunitToParents = null;
        this.setShard(resourceURI, handler.isShard());
        Set parents = handler.getParents().stream().map(URI::createURI).collect(Collectors.toSet());
        this.subunitToParents.putAll((Object)resourceURI, parents);
    }
}

