/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.util.PackageClosure;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletePackageClosure
extends PackageClosure {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CompletePackageClosure.class);
    private boolean excludeEcore;

    public CompletePackageClosure() {
    }

    public CompletePackageClosure(boolean excludeEcore) {
        this.excludeEcore = excludeEcore;
    }

    @Override
    protected void handleEPackage(EPackage ePackage, Set<EPackage> visitedPackages) {
        if (ePackage != null && visitedPackages.add(ePackage)) {
            if (this.excludeEcore && (EcorePackage.eINSTANCE == ePackage || "http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI()))) {
                return;
            }
            HashSet<Object> visited = new HashSet<Object>();
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                this.handleEClassifier(eClassifier, visitedPackages, visited);
            }
            for (Object e : visited) {
                if (!(e instanceof EClassifier)) continue;
                EClassifier classifier = (EClassifier)e;
                EPackage p = classifier.getEPackage();
                if (p != null) {
                    if (!visitedPackages.add(p) || !TRACER.isEnabled()) continue;
                    TRACER.trace("Found package " + p.getNsURI());
                    continue;
                }
                OM.LOG.warn(MessageFormat.format(Messages.getString("CompletePackageClosure.0"), classifier.getName()));
            }
        }
    }

    protected void handleEClassifier(EClassifier classifier, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (classifier != null && visited.add(classifier)) {
            this.handleEPackage(classifier.getEPackage(), visitedPackages);
            this.handleETypeParameters((EList<ETypeParameter>)classifier.getETypeParameters(), visitedPackages, visited);
            if (classifier instanceof EClass) {
                EClass eClass = (EClass)classifier;
                this.handleEStructuralFeatures((List<EStructuralFeature>)eClass.getEStructuralFeatures(), visitedPackages, visited);
                this.handleEOperations((List<EOperation>)eClass.getEOperations(), visitedPackages, visited);
                this.handleEGenericTypes((EList<EGenericType>)eClass.getEGenericSuperTypes(), visitedPackages, visited);
            }
        }
    }

    protected void handleEStructuralFeatures(List<EStructuralFeature> structuralFeatures, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (structuralFeatures != null) {
            for (EStructuralFeature structuralFeature : structuralFeatures) {
                this.handleEGenericType(structuralFeature.getEGenericType(), visitedPackages, visited);
            }
        }
    }

    protected void handleEOperations(List<EOperation> operations, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (operations != null) {
            for (EOperation operation : operations) {
                this.handleEGenericType(operation.getEGenericType(), visitedPackages, visited);
                this.handleETypeParameters((EList<ETypeParameter>)operation.getETypeParameters(), visitedPackages, visited);
                this.handleEParameters((List<EParameter>)operation.getEParameters(), visitedPackages, visited);
                this.handleEGenericTypes((EList<EGenericType>)operation.getEGenericExceptions(), visitedPackages, visited);
            }
        }
    }

    protected void handleEParameters(List<EParameter> parameters, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (parameters != null) {
            for (EParameter parameter : parameters) {
                this.handleEClassifier(parameter.getEType(), visitedPackages, visited);
                this.handleEGenericType(parameter.getEGenericType(), visitedPackages, visited);
            }
        }
    }

    protected void handleEGenericTypes(EList<EGenericType> genericTypes, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (genericTypes != null) {
            for (EGenericType genericType : genericTypes) {
                this.handleEGenericType(genericType, visitedPackages, visited);
            }
        }
    }

    protected void handleEGenericType(EGenericType genericType, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (genericType != null && visited.add(genericType)) {
            this.handleEClassifier(genericType.getEClassifier(), visitedPackages, visited);
            this.handleEClassifier(genericType.getERawType(), visitedPackages, visited);
            this.handleEGenericType(genericType.getELowerBound(), visitedPackages, visited);
            this.handleEGenericType(genericType.getEUpperBound(), visitedPackages, visited);
            this.handleEGenericTypes((EList<EGenericType>)genericType.getETypeArguments(), visitedPackages, visited);
            this.handleETypeParameter(genericType.getETypeParameter(), visitedPackages, visited);
        }
    }

    protected void handleETypeParameters(EList<ETypeParameter> typeParameters, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (typeParameters != null) {
            for (ETypeParameter typeParameter : typeParameters) {
                this.handleETypeParameter(typeParameter, visitedPackages, visited);
            }
        }
    }

    protected void handleETypeParameter(ETypeParameter typeParameter, Set<EPackage> visitedPackages, Set<Object> visited) {
        if (typeParameter != null) {
            this.handleEGenericTypes((EList<EGenericType>)typeParameter.getEBounds(), visitedPackages, visited);
        }
    }
}

