/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchFeatureInfo;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAnalyzerFeatureInfo {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOAnalyzerFeatureInfo.class);
    private Map<CDOFetchFeatureInfo, CDOFetchFeatureInfo> featureStats = new HashMap<CDOFetchFeatureInfo, CDOFetchFeatureInfo>();
    private Map<EClass, CDOFetchRule> fetchRules = new HashMap<EClass, CDOFetchRule>();

    public Collection<CDOFetchRule> getRules(EClass eClass, EStructuralFeature feature) {
        return this.fetchRules.values();
    }

    public synchronized CDOFetchFeatureInfo getFeatureStat(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(eClass, feature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        if (featureRule == null) {
            featureRule = search;
            this.featureStats.put(search, featureRule);
        }
        return featureRule;
    }

    public boolean isActive(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(eClass, feature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        return featureRule != null && featureRule.isActive();
    }

    public void activate(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo info = this.getFeatureStat(eClass, feature);
        if (!info.isActive()) {
            info.setActive(true);
            this.addRule(eClass, feature);
        }
    }

    public void deactivate(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo info = this.getFeatureStat(eClass, feature);
        if (info.isActive()) {
            info.setActive(false);
            this.removeRule(eClass, feature);
        }
    }

    private void addRule(EClass eClass, EStructuralFeature feature) {
        CDOFetchRule fetchRule;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding rule : {0}.{1}", new Object[]{eClass.getName(), feature.getName()});
        }
        if ((fetchRule = this.fetchRules.get(eClass)) == null) {
            fetchRule = new CDOFetchRule(eClass);
            this.fetchRules.put(eClass, fetchRule);
        }
        fetchRule.addFeature(feature);
    }

    private void removeRule(EClass eClass, EStructuralFeature feature) {
        CDOFetchRule fetchRule;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing rule : {0}.{1}", new Object[]{eClass.getName(), feature.getName()});
        }
        if ((fetchRule = this.fetchRules.get(eClass)) == null) {
            return;
        }
        fetchRule.removeFeature(feature);
    }
}

