/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.parser.antlr.AbstractAntlrGeneratorFragment;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardRemover;

public class XtextAntlrUiGeneratorFragment
extends AbstractAntlrGeneratorFragment {
    private boolean removeBacktrackingGuards = false;
    private int lookaheadThreshold = Integer.MAX_VALUE;
    private boolean partialParsing;

    public void setPartialParsing(boolean partialParsing) {
        this.partialParsing = partialParsing;
    }

    public boolean isPartialParsing() {
        return this.partialParsing;
    }

    public void setRemoveBacktrackingGuards(boolean removeBacktrackingGuards) {
        this.removeBacktrackingGuards = removeBacktrackingGuards;
    }

    public void setLookaheadThreshold(String lookaheadThreshold) {
        this.lookaheadThreshold = Integer.parseInt(lookaheadThreshold);
    }

    @Deprecated
    protected void removeBacktrackingGuardsIfEnabled(String absoluteGrammarFileName) {
        this.removeBacktrackingGuardsIfEnabled(absoluteGrammarFileName, Charset.defaultCharset());
    }

    protected void removeBacktrackingGuardsIfEnabled(String absoluteGrammarFileName, Charset encoding) {
        if (this.removeBacktrackingGuards) {
            String javaFile = absoluteGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
            String content = this.readFileIntoString(javaFile, encoding);
            BacktrackingGuardRemover remover = new BacktrackingGuardRemover(content, this.lookaheadThreshold);
            String newContent = remover.transform();
            this.writeStringIntoFile(javaFile, newContent, encoding);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        String srcUiGenPath = ctx.getOutput().getOutlet("SRC_GEN_IDE").getPath();
        String encoding = this.getEncoding(ctx, "SRC_GEN_IDE");
        String absoluteGrammarFileName = String.valueOf(srcUiGenPath) + "/" + XtextAntlrUiGeneratorFragment.getGrammarFileName(grammar, this.getNaming()).replace('.', '/') + ".g";
        this.addAntlrParam("-fo");
        this.addAntlrParam(absoluteGrammarFileName.substring(0, absoluteGrammarFileName.lastIndexOf(47)));
        this.getAntlrTool().runWithEncodingAndParams(absoluteGrammarFileName, encoding, this.getAntlrParams());
        Charset charset = Charset.forName(this.getEncoding(ctx, "SRC_GEN_IDE"));
        this.simplifyUnorderedGroupPredicatesIfRequired(grammar, absoluteGrammarFileName, charset);
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, charset);
        this.suppressWarnings(absoluteGrammarFileName, charset);
        this.removeBacktrackingGuardsIfEnabled(absoluteGrammarFileName, charset);
        this.normalizeLineDelimiters(absoluteGrammarFileName, charset);
        this.normalizeTokens(absoluteGrammarFileName, charset);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.getOptions().isBacktrackLexer()) {
            issues.addError("This fragment does not support the option 'backtracking' for the lexer. Use 'org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment' instead");
        }
        if (this.getOptions().isIgnoreCase()) {
            issues.addError("This fragment does not support the option 'ignoreCase'. Use 'org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment' instead");
        }
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        BindFactory binder = new BindFactory();
        if (this.getNaming().hasIde()) {
            binder.addTypeToType("org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext.Factory", "org.eclipse.xtext.ui.editor.contentassist.antlr.DelegatingContentAssistContextFactory");
            binder.addTypeToType("org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser", XtextAntlrUiGeneratorFragment.getParserClassName(grammar, this.getNaming()));
        } else {
            binder.addTypeToType("org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext.Factory", "org.eclipse.xtext.ui.editor.contentassist.antlr.ParserBasedContentAssistContextFactory");
            binder.addTypeToType("org.eclipse.xtext.ui.editor.contentassist.antlr.IContentAssistParser", XtextAntlrUiGeneratorFragment.getParserClassName(grammar, this.getNaming()));
        }
        binder.addConfiguredBinding("ContentAssistLexerProvider", "binder.bind(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class)" + ".toProvider(org.eclipse.xtext.parser.antlr.LexerProvider.create(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class))");
        if (this.getNaming().hasIde()) {
            binder.addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ide.LexerIdeBindings.CONTENT_ASSIST)).to(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class)");
        } else {
            binder.addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ui.LexerUIBindings.CONTENT_ASSIST)).to(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class)");
        }
        if (this.partialParsing) {
            if (this.getNaming().hasIde()) {
                binder.addTypeToType("org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory", "org.eclipse.xtext.ide.editor.contentassist.antlr.PartialContentAssistContextFactory");
            } else {
                binder.addTypeToType("org.eclipse.xtext.ui.editor.contentassist.antlr.ParserBasedContentAssistContextFactory.StatefulFactory", "org.eclipse.xtext.ui.editor.contentassist.antlr.ParserBasedContentAssistContextFactory.PartialStatefulFactory");
            }
        }
        return binder.getBindings();
    }

    @Override
    public String[] getExportedPackagesIde(Grammar grammar) {
        String caAntlrpackage = String.valueOf(this.getNaming().basePackageIde(grammar)) + ".contentassist.antlr";
        return new String[]{caAntlrpackage, String.valueOf(caAntlrpackage) + ".internal"};
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return ImmutableList.of((Object)((Object)this.getOptions()), (Object)this.partialParsing, (Object)this.getNaming().hasIde());
    }

    public static String getParserClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageIde(g)) + ".contentassist.antlr." + GrammarUtil.getSimpleName((Grammar)g) + "Parser";
    }

    public static String getInternalLexerClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageIde(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getSimpleName((Grammar)g) + "Lexer";
    }

    public static String getInternalParserClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageIde(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getSimpleName((Grammar)g) + "Parser";
    }

    public static String getGrammarFileName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageIde(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getSimpleName((Grammar)g);
    }

    public static Collection<Alternatives> getAllAlternatives(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Alternatives.class);
    }

    public static Collection<UnorderedGroup> getAllUnorderedGroups(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, UnorderedGroup.class);
    }

    public static Collection<Group> getAllGroups(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Group.class);
    }

    public static Collection<Assignment> getAllAssignments(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Assignment.class);
    }

    public static Collection<AbstractElement> getAllPredicatedElements(Grammar g) {
        Collection<AbstractElement> unfiltered = XtextAntlrUiGeneratorFragment.getAllElementsByType(g, AbstractElement.class);
        Collection result = Collections2.filter(unfiltered, (Predicate)new Predicate<AbstractElement>(){

            public boolean apply(AbstractElement input) {
                return input.isPredicated() || input.isFirstSetPredicated();
            }
        });
        return result;
    }

    private static <T extends AbstractElement> Collection<T> getAllElementsByType(Grammar g, Class<T> type) {
        List allParserRules = GrammarUtil.allParserRules((Grammar)g);
        ArrayList result = new ArrayList(30);
        for (ParserRule rule : allParserRules) {
            result.addAll(EcoreUtil2.getAllContentsOfType((EObject)rule, type));
        }
        List allEnumRules = GrammarUtil.allEnumRules((Grammar)g);
        for (EnumRule rule : allEnumRules) {
            result.addAll(EcoreUtil2.getAllContentsOfType((EObject)rule, type));
        }
        return result;
    }
}

