/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.library.executor.LazyModelManager;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class PivotExecutorManager
extends ExecutorManager {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull IdResolver idResolver;
    protected final @NonNull EObject contextObject;
    private @Nullable ModelManager modelManager = null;

    public PivotExecutorManager(@NonNull EnvironmentFactory environmentFactory, @NonNull EObject contextObject) {
        super(environmentFactory.getCompleteEnvironment());
        this.environmentFactory = environmentFactory;
        this.idResolver = environmentFactory.getIdResolver();
        this.contextObject = contextObject;
        this.idResolver.addRoot(ClassUtil.nonNullEMF(EcoreUtil.getRootContainer((EObject)contextObject)));
    }

    protected @NonNull IdResolver createIdResolver() {
        return this.environmentFactory.getIdResolver();
    }

    @Override
    public @NonNull Type getDynamicTypeOf(@Nullable Object value) {
        return this.idResolver.getDynamicTypeOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ModelManager getModelManager() {
        ModelManager modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            PivotExecutorManager pivotExecutorManager = this;
            synchronized (pivotExecutorManager) {
                modelManager2 = this.modelManager;
                if (modelManager2 == null) {
                    this.modelManager = modelManager2 = new LazyModelManager(this.contextObject){

                        @Override
                        protected boolean isInstance(@NonNull Type type, @NonNull EObject element) {
                            EClass eClass = ClassUtil.nonNullEMF(element.eClass());
                            Class elementType = PivotExecutorManager.this.idResolver.getInheritance((EClassifier)eClass).getPivotClass();
                            return elementType.conformsTo(PivotExecutorManager.this.standardLibrary, type);
                        }
                    };
                }
            }
        }
        return modelManager2;
    }

    @Override
    public @NonNull IdResolver getIdResolver() {
        return this.idResolver;
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.environmentFactory.getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        return this.idResolver.getStaticTypeOf(value);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }
}

