/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IndentingLogger;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationEnvironment;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractExecutor
implements ExecutorInternal {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    protected final @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    @Deprecated
    protected final ModelManager modelManager;
    private EvaluationEnvironment.EvaluationEnvironmentExtension rootEvaluationEnvironment = null;
    private EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment = null;
    private EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor;
    private Map<String, Pattern> regexPatterns = null;
    private EvaluationLogger logger = IndentingLogger.OUT;

    protected AbstractExecutor(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.modelManager = null;
    }

    @Deprecated
    protected AbstractExecutor(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull ModelManager modelManager) {
        this.environmentFactory = environmentFactory;
        this.modelManager = modelManager;
    }

    @Override
    public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.evaluationEnvironment.add(referredVariable, value);
    }

    protected @NonNull EvaluationVisitor.EvaluationVisitorExtension createEvaluationVisitor() {
        AbstractExtendingVisitor result = new BasicEvaluationVisitor(this);
        if (this.environmentFactory.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor((EvaluationVisitor)((Object)result));
        }
        return result;
    }

    protected @NonNull Map<String, Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    protected @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createNestedEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        return new BasicEvaluationEnvironment(evaluationEnvironment, executableObject, callingObject);
    }

    @Override
    @Deprecated
    public @NonNull Evaluator createNestedEvaluator() {
        return this;
    }

    protected @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createRootEvaluationEnvironment(@NonNull NamedElement executableObject) {
        return new BasicEvaluationEnvironment(this, executableObject);
    }

    @Override
    public void dispose() {
    }

    @Override
    public @Nullable Object evaluate(@NonNull OCLExpression body) {
        return this.evaluationVisitor.evaluate(body);
    }

    @Override
    public @NonNull CompleteEnvironment getCompleteEnvironment() {
        return this.environmentFactory.getCompleteEnvironment();
    }

    @Override
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        if (resultValue == null) {
            return 4;
        }
        if (resultValue instanceof InvalidValueException) {
            return 8;
        }
        return severityPreference;
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        return ClassUtil.nonNullState(this.evaluationEnvironment);
    }

    @Override
    public @NonNull EvaluationVisitor.EvaluationVisitorExtension getEvaluationVisitor() {
        EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor2 = this.evaluationVisitor;
        if (evaluationVisitor2 == null) {
            this.evaluationVisitor = evaluationVisitor2 = this.createEvaluationVisitor();
        }
        return evaluationVisitor2;
    }

    @Override
    public @NonNull IdResolver.IdResolverExtension getIdResolver() {
        return (IdResolver.IdResolverExtension)this.environmentFactory.getIdResolver();
    }

    @Override
    public @Nullable EvaluationLogger getLogger() {
        return this.logger;
    }

    @Override
    public @NonNull MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @Override
    public @NonNull EvaluationEnvironment getRootEvaluationEnvironment() {
        return ClassUtil.nonNullState(this.rootEvaluationEnvironment);
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.environmentFactory.getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    public @Nullable Object getValueOf(@NonNull TypedElement referredVariable) {
        return this.evaluationEnvironment.getValueOf(referredVariable);
    }

    @Override
    public @NonNull EvaluationEnvironment initializeEvaluationEnvironment(@NonNull NamedElement executableObject) {
        EvaluationEnvironment.EvaluationEnvironmentExtension rootEvaluationEnvironment = this.createRootEvaluationEnvironment(executableObject);
        this.setRootEvaluationEnvironment(rootEvaluationEnvironment);
        return rootEvaluationEnvironment;
    }

    @Override
    public @Nullable Object internalExecuteNavigationCallExp(@NonNull NavigationCallExp navigationCallExp, @NonNull Property referredProperty, @Nullable Object sourceValue) {
        if (navigationCallExp.isIsSafe() && sourceValue == null) {
            return null;
        }
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        LibraryProperty.LibraryPropertyExtension implementation = (LibraryProperty.LibraryPropertyExtension)metamodelManager.getImplementation(navigationCallExp, sourceValue, referredProperty);
        try {
            return implementation.evaluate(this, navigationCallExp.getTypeId(), sourceValue);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, referredProperty, sourceValue, navigationCallExp);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.evaluationVisitor.isCanceled();
    }

    @Override
    public void popEvaluationEnvironment() {
        this.evaluationEnvironment = ClassUtil.nonNullState(this.evaluationEnvironment.getParentEvaluationEnvironment());
    }

    @Override
    public @NonNull EvaluationEnvironment pushEvaluationEnvironment(@NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        EvaluationEnvironment.EvaluationEnvironmentExtension nestedEvaluationEnvironment;
        EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment2 = ClassUtil.nonNullState(this.evaluationEnvironment);
        this.evaluationEnvironment = nestedEvaluationEnvironment = this.createNestedEvaluationEnvironment(evaluationEnvironment2, executableObject, callingObject);
        return nestedEvaluationEnvironment;
    }

    @Override
    public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.evaluationEnvironment.replace(referredVariable, value);
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.evaluationVisitor.setCanceled(isCanceled);
    }

    @Override
    public void setLogger(@Nullable EvaluationLogger logger) {
        this.logger = logger;
    }

    protected void setRootEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment) {
        assert (this.rootEvaluationEnvironment == null);
        this.rootEvaluationEnvironment = evaluationEnvironment;
        this.evaluationEnvironment = evaluationEnvironment;
    }
}

