/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalMappingStrategy
extends Lifecycle
implements IMappingStrategy {
    private Map<String, String> properties;
    private IDBStore store;
    private IMappingStrategy delegate;

    public IMappingStrategy getDelegate() {
        return this.delegate;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.delegate != null) {
            return this.delegate.getProperties();
        }
        if (this.properties != null) {
            return this.properties;
        }
        return new HashMap<String, String>();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        if (this.delegate != null) {
            this.delegate.setProperties(properties);
        } else {
            this.properties = properties;
        }
    }

    @Override
    public IDBStore getStore() {
        if (this.delegate != null) {
            return this.delegate.getStore();
        }
        return this.store;
    }

    @Override
    public void setStore(IDBStore store) {
        if (this.delegate != null) {
            this.delegate.setStore(store);
        } else {
            this.store = store;
        }
    }

    @Override
    public ITypeMapping createValueMapping(EStructuralFeature feature) {
        return this.delegate.createValueMapping(feature);
    }

    @Override
    public IListMapping createListMapping(EClass containingClass, EStructuralFeature feature) {
        return this.delegate.createListMapping(containingClass, feature);
    }

    @Override
    public String getTableName(ENamedElement element) {
        return this.delegate.getTableName(element);
    }

    @Override
    public String getTableName(EClass containingClass, EStructuralFeature feature) {
        return this.delegate.getTableName(containingClass, feature);
    }

    @Override
    public String getFieldName(EStructuralFeature feature) {
        return this.delegate.getFieldName(feature);
    }

    @Override
    public void createMapping(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.delegate.createMapping(connection, packageUnits, monitor);
    }

    @Override
    public void removeMapping(Connection connection, InternalCDOPackageUnit[] packageUnits) {
        this.delegate.removeMapping(connection, packageUnits);
    }

    @Override
    public IClassMapping getClassMapping(EClass eClass) {
        return this.delegate.getClassMapping(eClass);
    }

    @Override
    public Map<EClass, IClassMapping> getClassMappings() {
        return this.delegate.getClassMappings();
    }

    @Override
    public Map<EClass, IClassMapping> getClassMappings(boolean createOnDemand) {
        return this.delegate.getClassMappings(createOnDemand);
    }

    @Override
    public boolean hasDeltaSupport() {
        return this.delegate.hasDeltaSupport();
    }

    @Override
    public boolean hasAuditSupport() {
        return this.delegate.hasAuditSupport();
    }

    @Override
    public boolean hasBranchingSupport() {
        return this.delegate.hasBranchingSupport();
    }

    @Override
    public void queryResources(IDBStoreAccessor accessor, IStoreAccessor.QueryResourcesContext context) {
        this.delegate.queryResources(accessor, context);
    }

    @Override
    public void queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context) {
        this.delegate.queryXRefs(accessor, context);
    }

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.delegate.readObjectType(accessor, id);
    }

    @Override
    public CloseableIterator<CDOID> readObjectIDs(IDBStoreAccessor accessor) {
        return this.delegate.readObjectIDs(accessor);
    }

    @Override
    public void repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        this.delegate.repairAfterCrash(dbAdapter, connection);
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.delegate.handleRevisions(accessor, eClass, branch, timeStamp, exactTime, handler);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, OMMonitor monitor, CDOChangeSetSegment[] segments) {
        return this.delegate.readChangeSet(accessor, monitor, segments);
    }

    @Override
    public void rawExport(IDBStoreAccessor accessor, CDODataOutput out, int lastReplicatedBranchID, int lastBranchID, long lastReplicatedCommitTime, long lastCommitTime) throws IOException {
        this.delegate.rawExport(accessor, out, lastReplicatedBranchID, lastBranchID, lastReplicatedCommitTime, lastCommitTime);
    }

    @Override
    public void rawImport(IDBStoreAccessor accessor, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        this.delegate.rawImport(accessor, in, fromCommitTime, toCommitTime, monitor);
    }

    @Override
    public String getListJoin(String attrTable, String listTable) {
        return this.delegate.getListJoin(attrTable, listTable);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        boolean auditing = this.getBooleanProperty("supportingAudits");
        boolean branching = this.getBooleanProperty("supportingBranches");
        boolean withRanges = false;
        if (auditing || branching) {
            withRanges = this.getBooleanProperty("withRanges");
        }
        this.delegate = CDODBUtil.createHorizontalMappingStrategy(auditing, branching, withRanges);
        this.delegate.setStore(this.store);
        this.delegate.setProperties(this.properties);
        LifecycleUtil.activate((Object)this.delegate);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.delegate);
        super.doDeactivate();
    }

    private boolean getBooleanProperty(String prop) {
        String valueAudits = this.properties.get(prop);
        if (valueAudits != null) {
            return Boolean.valueOf(valueAudits);
        }
        return false;
    }
}

