/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.part;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.update.DiagramUpdater;
import org.eclipse.opencert.vocabulary.Category;
import org.eclipse.opencert.vocabulary.SourceOfDefinition;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyPackage;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyLinkDescriptor;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyNodeDescriptor;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyVisualIDRegistry;
import org.eclipse.opencert.vocabulary.diagram.providers.VocabularyElementTypes;

public class VocabularyDiagramUpdater {
    public static final DiagramUpdater TYPED_INSTANCE = new DiagramUpdater(){

        public List<VocabularyNodeDescriptor> getSemanticChildren(View view) {
            return VocabularyDiagramUpdater.getSemanticChildren(view);
        }

        public List<VocabularyLinkDescriptor> getContainedLinks(View view) {
            return VocabularyDiagramUpdater.getContainedLinks(view);
        }

        public List<VocabularyLinkDescriptor> getIncomingLinks(View view) {
            return VocabularyDiagramUpdater.getIncomingLinks(view);
        }

        public List<VocabularyLinkDescriptor> getOutgoingLinks(View view) {
            return VocabularyDiagramUpdater.getOutgoingLinks(view);
        }
    };

    public static boolean isShortcutOrphaned(View view) {
        return !view.isSetElement() || view.getElement() == null || view.getElement().eIsProxy();
    }

    public static List<VocabularyNodeDescriptor> getSemanticChildren(View view) {
        switch (VocabularyVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return VocabularyDiagramUpdater.getVocabulary_1000SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<VocabularyNodeDescriptor> getVocabulary_1000SemanticChildren(View view) {
        int visualID;
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Vocabulary modelElement = (Vocabulary)view.getElement();
        LinkedList<VocabularyNodeDescriptor> result = new LinkedList<VocabularyNodeDescriptor>();
        for (Term childElement : modelElement.getTerms()) {
            visualID = VocabularyVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2001) continue;
            result.add(new VocabularyNodeDescriptor((EObject)childElement, visualID));
        }
        for (Term childElement : modelElement.getCategories()) {
            visualID = VocabularyVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2002) continue;
            result.add(new VocabularyNodeDescriptor((EObject)childElement, visualID));
        }
        for (Term childElement : modelElement.getSourcesOfDefinition()) {
            visualID = VocabularyVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2003) continue;
            result.add(new VocabularyNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<VocabularyLinkDescriptor> getContainedLinks(View view) {
        switch (VocabularyVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return VocabularyDiagramUpdater.getVocabulary_1000ContainedLinks(view);
            }
            case 2001: {
                return VocabularyDiagramUpdater.getTerm_2001ContainedLinks(view);
            }
            case 2002: {
                return VocabularyDiagramUpdater.getCategory_2002ContainedLinks(view);
            }
            case 2003: {
                return VocabularyDiagramUpdater.getSourceOfDefinition_2003ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<VocabularyLinkDescriptor> getIncomingLinks(View view) {
        switch (VocabularyVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return VocabularyDiagramUpdater.getTerm_2001IncomingLinks(view);
            }
            case 2002: {
                return VocabularyDiagramUpdater.getCategory_2002IncomingLinks(view);
            }
            case 2003: {
                return VocabularyDiagramUpdater.getSourceOfDefinition_2003IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<VocabularyLinkDescriptor> getOutgoingLinks(View view) {
        switch (VocabularyVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return VocabularyDiagramUpdater.getTerm_2001OutgoingLinks(view);
            }
            case 2002: {
                return VocabularyDiagramUpdater.getCategory_2002OutgoingLinks(view);
            }
            case 2003: {
                return VocabularyDiagramUpdater.getSourceOfDefinition_2003OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<VocabularyLinkDescriptor> getVocabulary_1000ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<VocabularyLinkDescriptor> getTerm_2001ContainedLinks(View view) {
        Term modelElement = (Term)view.getElement();
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_DefinedBy_4003(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_IsA_4004(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_HasA_4005(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_RefersTo_4006(modelElement));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getCategory_2002ContainedLinks(View view) {
        Category modelElement = (Category)view.getElement();
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Category_Terms_4001(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Category_SubCategories_4002(modelElement));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getSourceOfDefinition_2003ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<VocabularyLinkDescriptor> getTerm_2001IncomingLinks(View view) {
        Term modelElement = (Term)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Category_Terms_4001(modelElement, crossReferences));
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Term_IsA_4004(modelElement, crossReferences));
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Term_HasA_4005(modelElement, crossReferences));
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Term_RefersTo_4006(modelElement, crossReferences));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getCategory_2002IncomingLinks(View view) {
        Category modelElement = (Category)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Category_SubCategories_4002(modelElement, crossReferences));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getSourceOfDefinition_2003IncomingLinks(View view) {
        SourceOfDefinition modelElement = (SourceOfDefinition)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getIncomingFeatureModelFacetLinks_Term_DefinedBy_4003(modelElement, crossReferences));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getTerm_2001OutgoingLinks(View view) {
        Term modelElement = (Term)view.getElement();
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_DefinedBy_4003(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_IsA_4004(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_HasA_4005(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Term_RefersTo_4006(modelElement));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getCategory_2002OutgoingLinks(View view) {
        Category modelElement = (Category)view.getElement();
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Category_Terms_4001(modelElement));
        result.addAll(VocabularyDiagramUpdater.getOutgoingFeatureModelFacetLinks_Category_SubCategories_4002(modelElement));
        return result;
    }

    public static List<VocabularyLinkDescriptor> getSourceOfDefinition_2003OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Category_Terms_4001(Term target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getCategory_Terms()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.CategoryTerms_4001, 4001));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Category_SubCategories_4002(Category target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getCategory_SubCategories()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.CategorySubCategories_4002, 4002));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Term_DefinedBy_4003(SourceOfDefinition target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getTerm_DefinedBy()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.TermDefinedBy_4003, 4003));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Term_IsA_4004(Term target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getTerm_IsA()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.TermIsA_4004, 4004));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Term_HasA_4005(Term target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getTerm_HasA()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.TermHasA_4005, 4005));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getIncomingFeatureModelFacetLinks_Term_RefersTo_4006(Term target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != VocabularyPackage.eINSTANCE.getTerm_RefersTo()) continue;
            result.add(new VocabularyLinkDescriptor(setting.getEObject(), (EObject)target, VocabularyElementTypes.TermRefersTo_4006, 4006));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Category_Terms_4001(Category source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        for (Term destination : source.getTerms()) {
            result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.CategoryTerms_4001, 4001));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Category_SubCategories_4002(Category source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        for (Category destination : source.getSubCategories()) {
            result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.CategorySubCategories_4002, 4002));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Term_DefinedBy_4003(Term source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        SourceOfDefinition destination = source.getDefinedBy();
        if (destination == null) {
            return result;
        }
        result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.TermDefinedBy_4003, 4003));
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Term_IsA_4004(Term source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        for (Term destination : source.getIsA()) {
            result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.TermIsA_4004, 4004));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Term_HasA_4005(Term source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        for (Term destination : source.getHasA()) {
            result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.TermHasA_4005, 4005));
        }
        return result;
    }

    private static Collection<VocabularyLinkDescriptor> getOutgoingFeatureModelFacetLinks_Term_RefersTo_4006(Term source) {
        LinkedList<VocabularyLinkDescriptor> result = new LinkedList<VocabularyLinkDescriptor>();
        for (Term destination : source.getRefersTo()) {
            result.add(new VocabularyLinkDescriptor((EObject)source, (EObject)destination, VocabularyElementTypes.TermRefersTo_4006, 4006));
        }
        return result;
    }
}

