/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustAbsoluteBendpointsEditPolicyBase;
import org.eclipse.gmf.tooling.runtime.linklf.policies.SetAbsoluteBendpointsCommand;

public class AdjustSyntheticBendpointsEditPolicy
extends AdjustAbsoluteBendpointsEditPolicyBase {
    public static final String ROLE = String.valueOf(AdjustSyntheticBendpointsEditPolicy.class.getName()) + ":Role";

    @Override
    protected Command getAdjustLinksCommand(ChangeBoundsRequest req) {
        Point moveDelta = req.getMoveDelta();
        if (moveDelta.x == 0 && moveDelta.y == 0) {
            return null;
        }
        AdjustAbsoluteBendpointsEditPolicyBase.CachedEditPartsSet allMoved = AdjustSyntheticBendpointsEditPolicy.getMovedEditPartsSet(req);
        ICommand result = null;
        LinkedList<IGraphicalEditPart> queue = new LinkedList<IGraphicalEditPart>();
        queue.add(this.getHost());
        while (!queue.isEmpty()) {
            ConnectionEditPart nextLinkEP;
            GraphicalEditPart cur = (GraphicalEditPart)queue.removeFirst();
            for (Object nextLink : cur.getSourceConnections()) {
                if (!(nextLink instanceof ConnectionEditPart)) continue;
                nextLinkEP = (ConnectionEditPart)nextLink;
                ICommand nextAdjustment = this.getAdjustOneLinkCommand(nextLinkEP, req);
                result = AdjustSyntheticBendpointsEditPolicy.compose(result, nextAdjustment);
            }
            for (Object nextLink : cur.getTargetConnections()) {
                EditPart target;
                AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind move;
                if (!(nextLink instanceof ConnectionEditPart) || (move = allMoved.isMoved(target = (nextLinkEP = (ConnectionEditPart)nextLink).getSource())) != AdjustAbsoluteBendpointsEditPolicyBase.MovedNodeKind.NO) continue;
                ICommand nextAdjustment = this.getAdjustOneLinkCommand(nextLinkEP, req);
                result = AdjustSyntheticBendpointsEditPolicy.compose(result, nextAdjustment);
            }
            List children = cur.getChildren();
            queue.addAll(children);
        }
        return result == null ? null : new ICommandProxy(result.reduce());
    }

    private ICommand getAdjustOneLinkCommand(ConnectionEditPart linkEP, ChangeBoundsRequest req) {
        Connection conn = linkEP.getConnectionFigure();
        ConnectionRouter router = conn.getConnectionRouter();
        if (!(router instanceof OrthogonalRouter)) {
            return null;
        }
        if (!(linkEP.getNotationView() instanceof Edge)) {
            return null;
        }
        PointList points = conn.getPoints();
        if (points.size() <= 2) {
            return null;
        }
        if (!(conn.getRoutingConstraint() instanceof List)) {
            return null;
        }
        List d2dBendpoints = (List)conn.getRoutingConstraint();
        if (d2dBendpoints.size() >= points.size()) {
            return null;
        }
        SetAbsoluteBendpointsCommand result = new SetAbsoluteBendpointsCommand(linkEP.getEditingDomain());
        result.setEdge(linkEP);
        result.setNewPointList(points);
        return result;
    }
}

