/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.BorderedScalableImageFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ShapeFlowLayout;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.NotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.Util;

public class ShapeDecorator
extends AbstractDecorator
implements NotificationListener,
IChangeListener {
    protected NotificationManager notificationManager;
    protected static final int MARGIN_HEIGHT = 4;
    protected static final int MARGIN_WIDTH = 4;
    protected static final int IMAGE_WIDTH = 36;
    protected static final int IMAGE_HEIGHT = 36;
    public static final String SHAPE_DECORATOR_VISIBILITY = "shapeVisibility";
    public static final String SHAPE_DECORATOR_DIRECTION = "shapeDirection";
    protected CustomBooleanStyleObservableValue visibilityObservable;
    private CustomIntStyleObservableValue positionObservable;
    protected View view;

    public ShapeDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public static View getDecoratorTargetNode(IDecoratorTarget decoratorTarget) {
        View node = (View)decoratorTarget.getAdapter(View.class);
        return ShapeDecorator.getDecorableNode(node);
    }

    public static Node getDecorableNode(View node) {
        DescriptionStyle descStyle;
        if (node != null && !(node instanceof Diagram) && (descStyle = (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle())) != null) {
            return (Node)node;
        }
        return null;
    }

    public static boolean isDecorable(View node) {
        return ShapeDecorator.getDecorableNode(node) != null;
    }

    public void refresh() {
        List<RenderedImage> shapesToDisplay;
        boolean hasShapes;
        DescriptionStyle descStyle;
        this.removeDecoration();
        View node = ShapeDecorator.getDecoratorTargetNode((IDecoratorTarget)this.getDecoratorTarget());
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        if (node != null && (descStyle = this.getDescriptionStyle(node)) != null && this.isDecorationVisible(node) && (hasShapes = ShapeService.getInstance().hasShapeToDisplay((EObject)node)) && !(shapesToDisplay = ShapeService.getInstance().getShapeDecorationsToDisplay((EObject)node)).isEmpty()) {
            Figure figure = new Figure();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class)).getFigure());
            figure.setSize(mm.DPtoLP(shapesToDisplay.size() * 36), mm.DPtoLP(36));
            figure.setLayoutManager((LayoutManager)new ShapeFlowLayout());
            for (RenderedImage image : shapesToDisplay) {
                BorderedScalableImageFigure subFigure = new BorderedScalableImageFigure(image, false, true, true);
                figure.add((IFigure)subFigure);
            }
            if (this.isInCompartmentList(node) && !Util.isAffixedChildNode((EditPart)gep)) {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)figure, this.getDirection(node), -1, false));
            } else {
                OverlayLocator locator = new OverlayLocator(gep.getFigure(), this.getDirection(node));
                this.setDecoration(this.getDecoratorTarget().addDecoration((IFigure)figure, (Locator)locator, false));
            }
        }
    }

    public void notifyChanged(Notification notification) {
        this.refresh();
    }

    protected IDecoratorTarget.Direction getDirection(View node) {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        if (gep.getParent() != null && this.isInCompartmentList(node) && !Util.isAffixedChildNode((EditPart)gep)) {
            return IDecoratorTarget.Direction.EAST;
        }
        IntValueStyle directionStyle = (IntValueStyle)node.getNamedStyle(NotationPackage.eINSTANCE.getIntValueStyle(), SHAPE_DECORATOR_DIRECTION);
        if (directionStyle != null) {
            int direction = directionStyle.getIntValue();
            switch (direction) {
                case 0: {
                    return IDecoratorTarget.Direction.NORTH_WEST;
                }
                case 1: {
                    return IDecoratorTarget.Direction.NORTH;
                }
                case 2: {
                    return IDecoratorTarget.Direction.NORTH_EAST;
                }
                case 3: {
                    return IDecoratorTarget.Direction.WEST;
                }
                case 4: {
                    return IDecoratorTarget.Direction.CENTER;
                }
                case 5: {
                    return IDecoratorTarget.Direction.EAST;
                }
                case 6: {
                    return IDecoratorTarget.Direction.SOUTH_WEST;
                }
                case 7: {
                    return IDecoratorTarget.Direction.SOUTH;
                }
                case 8: {
                    return IDecoratorTarget.Direction.SOUTH_EAST;
                }
            }
            return IDecoratorTarget.Direction.NORTH_WEST;
        }
        return IDecoratorTarget.Direction.NORTH_WEST;
    }

    protected boolean isDecorationVisible(View node) {
        BooleanValueStyle visibilityStyle = (BooleanValueStyle)node.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), SHAPE_DECORATOR_VISIBILITY);
        if (visibilityStyle != null) {
            return visibilityStyle.isBooleanValue();
        }
        return false;
    }

    protected boolean isInCompartmentList(View node) {
        EditPart EP;
        EditPolicy editPolicy;
        EObject container;
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        return gep != null && gep.getRoot() != null && (container = node.eContainer()) instanceof View && !((editPolicy = (EP = DiagramEditPartsUtil.getEditPartFromView((View)container, (EditPart)gep)).getEditPolicy((Object)"LayoutEditPolicy")) instanceof XYLayoutEditPolicy);
    }

    protected DescriptionStyle getDescriptionStyle(View node) {
        return (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
    }

    public void activate() {
        this.view = this.getView();
        if (this.view == null) {
            return;
        }
        this.notificationManager = ShapeService.getInstance().createNotificationManager(this.getDiagramEventBroker(), (EObject)this.view, this);
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain((IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class));
        if (domain != null) {
            this.visibilityObservable = new CustomBooleanStyleObservableValue(this.view, (EditingDomain)domain, SHAPE_DECORATOR_VISIBILITY);
            this.visibilityObservable.addChangeListener(this);
            this.positionObservable = new CustomIntStyleObservableValue(this.view, (EditingDomain)domain, SHAPE_DECORATOR_DIRECTION);
            this.positionObservable.addChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.view == null) {
            return;
        }
        this.notificationManager.dispose();
        this.notificationManager = null;
        if (this.visibilityObservable != null) {
            this.visibilityObservable.dispose();
            this.visibilityObservable = null;
        }
        if (this.positionObservable != null) {
            this.positionObservable.dispose();
            this.positionObservable = null;
        }
        super.deactivate();
    }

    protected View getView() {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        if (gep == null) {
            return null;
        }
        View view = (View)gep.getModel();
        return view;
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain(IGraphicalEditPart editPart) {
        if (editPart != null) {
            return editPart.getEditingDomain();
        }
        return null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain(gep);
        if (editingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return null;
    }

    public void handleChange(ChangeEvent event) {
        this.refresh();
    }

    public class OverlayLocator
    implements Locator {
        private IFigure reference;
        private IDecoratorTarget.Direction position = null;

        public OverlayLocator(IFigure reference, IDecoratorTarget.Direction position) {
            assert (reference != null);
            this.reference = reference;
            this.position = position;
        }

        public void relocate(IFigure target) {
            IFigure parentFigure;
            PrecisionRectangle bounds = this.reference instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)this.reference).getHandleBounds()) : new PrecisionRectangle(this.reference.getBounds());
            this.reference.translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            int width = 36;
            int height = 36;
            if (target.getChildren().size() == 1 && (parentFigure = (IFigure)target.getChildren().get(0)).getChildren().size() > 1) {
                width = parentFigure.getChildren().size() * 36 + (parentFigure.getChildren().size() - 1) * 4;
            }
            if (IDecoratorTarget.Direction.NORTH_WEST.equals(this.position)) {
                target.setLocation(bounds.getTopLeft().getTranslated(4, 4));
            } else if (IDecoratorTarget.Direction.NORTH.equals(this.position)) {
                target.setLocation(bounds.getTop().getTranslated(-width / 2, 4));
            } else if (IDecoratorTarget.Direction.NORTH_EAST.equals(this.position)) {
                target.setLocation(bounds.getTopRight().getTranslated(-4 - width, 4));
            } else if (IDecoratorTarget.Direction.SOUTH_WEST.equals(this.position)) {
                target.setLocation(bounds.getBottomLeft().getTranslated(4, -4 - height));
            } else if (IDecoratorTarget.Direction.SOUTH.equals(this.position)) {
                target.setLocation(bounds.getBottom().getTranslated(-width / 2, -4 - height));
            } else if (IDecoratorTarget.Direction.SOUTH_EAST.equals(this.position)) {
                target.setLocation(bounds.getBottomRight().getTranslated(-4 - width, -4 - height));
            } else if (IDecoratorTarget.Direction.WEST.equals(this.position)) {
                target.setLocation(bounds.getLeft().getTranslated(4, -height / 2));
            } else if (IDecoratorTarget.Direction.EAST.equals(this.position)) {
                target.setLocation(bounds.getRight().getTranslated(-4 - width, -height / 2));
            } else if (IDecoratorTarget.Direction.CENTER.equals(this.position)) {
                target.setLocation(bounds.getCenter().getTranslated(-width / 2, -height / 2));
            }
        }
    }
}

