/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class CreateViewAction
extends DiagramAction {
    protected String semanticHint;

    public CreateViewAction(IWorkbenchPage workbenchPage, String actionId, String semanticHint, String label, ImageDescriptor imageDescriptor) {
        super(workbenchPage);
        this.setId(actionId);
        this.setSemanticHint(semanticHint);
        this.setText(label);
        this.setToolTipText(label);
        this.setImageDescriptor(imageDescriptor);
    }

    protected Request createTargetRequest() {
        CreateViewRequest.ViewDescriptor viewDescriptor = this.getId().equals("addNoteAction") ? new CreateViewRequest.ViewDescriptor(null, Node.class, ViewType.NOTE, this.getPreferencesHint()) : new CreateViewRequest.ViewDescriptor(null, Node.class, ViewType.TEXT, this.getPreferencesHint());
        return new CreateViewRequest(viewDescriptor);
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected void setSemanticHint(String hint) {
        this.semanticHint = hint;
    }

    protected String getSemanticHint() {
        return this.semanticHint;
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        CreateViewRequest req = (CreateViewRequest)this.getTargetRequest();
        req.setLocation(this.getMouseLocation());
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        super.doRun(progressMonitor);
        this.selectAddedObject();
    }

    protected void selectAddedObject() {
        Object result = ((CreateRequest)this.getTargetRequest()).getNewObject();
        if (!(result instanceof Collection)) {
            return;
        }
        final ArrayList editparts = new ArrayList(1);
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        if (viewer == null) {
            return;
        }
        Map editpartRegistry = viewer.getEditPartRegistry();
        for (Object viewAdaptable : (Collection)result) {
            Object editPart;
            if (!(viewAdaptable instanceof IAdaptable) || (editPart = editpartRegistry.get(((IAdaptable)viewAdaptable).getAdapter(View.class))) == null) continue;
            editparts.add(editPart);
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    EditPart editPart = (EditPart)editparts.get(0);
                    editPart.performRequest(new Request((Object)"direct edit"));
                }
            });
        }
    }
}

