/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.pluginexplorer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;

public class PluginsContentProvider
implements ITreeContentProvider {
    public static final Object treeRoot = new Object();
    private Plugin[] plugins;
    private String filter;

    public PluginsContentProvider(Plugin[] plugins, String filter) {
        this.plugins = plugins;
        this.filter = filter;
        if (this.filter != null && this.filter.isEmpty()) {
            this.filter = null;
        }
    }

    private Object[] getFilteredPlugins() {
        if (this.filter == null) {
            return this.plugins;
        }
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        int i = 0;
        while (i != this.plugins.length) {
            String name = this.plugins[i].getName();
            if (name.contains(this.filter)) {
                list.add(this.plugins[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getFilteredPlugins();
    }

    public Object[] getChildren(Object element) {
        if (element == treeRoot) {
            return this.getFilteredPlugins();
        }
        if (element instanceof Plugin) {
            return ((Plugin)element).entries().toArray();
        }
        if (element instanceof PluginEntry) {
            return ((PluginEntry)element).children().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element == treeRoot) {
            return null;
        }
        if (element instanceof Plugin) {
            return treeRoot;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == treeRoot) {
            return true;
        }
        if (element instanceof Plugin) {
            return ((Plugin)element).hasEntries();
        }
        if (element instanceof PluginEntry) {
            return ((PluginEntry)element).hasChildren();
        }
        return false;
    }
}

