/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.infra.mappings.mapping.MapModel;
import org.eclipse.opencert.infra.mappings.mapping.MappingFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GroupMapNew
extends Dialog {
    private CDOTransaction transactionGroup = null;
    protected MapGroup mapGroup;
    protected MapModel mapModel;
    protected String sPath;
    protected Text idText;
    protected Text nameText;
    protected Text descText;
    protected boolean bcheck = true;
    Map<Object, Object> options = new HashMap<Object, Object>();

    public GroupMapNew(Shell parentShell, CDOSession sessionCDO, String path) {
        super(parentShell);
        try {
            this.transactionGroup = sessionCDO.openTransaction();
            this.sPath = path;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Not valid model file", (String)exception.toString());
        }
    }

    public GroupMapNew(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 2;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Label idLabel = new Label(contents, 0);
        idLabel.setText("ID");
        GridData idLabelGridData = new GridData();
        idLabelGridData.horizontalAlignment = 4;
        idLabelGridData.verticalAlignment = 4;
        idLabel.setLayoutData((Object)idLabelGridData);
        this.idText = new Text(contents, 0);
        GridData idTextGridData = new GridData();
        idTextGridData.horizontalAlignment = 4;
        idTextGridData.verticalAlignment = 4;
        this.idText.setLayoutData((Object)idTextGridData);
        Label nameLabel = new Label(contents, 0);
        nameLabel.setText("Name");
        GridData nameLabelGridData = new GridData();
        nameLabelGridData.grabExcessHorizontalSpace = true;
        nameLabelGridData.minimumWidth = 20;
        nameLabelGridData.horizontalAlignment = 4;
        nameLabelGridData.verticalAlignment = 4;
        nameLabel.setLayoutData((Object)nameLabelGridData);
        this.nameText = new Text(contents, 0);
        GridData nameTextGridData = new GridData();
        nameTextGridData.grabExcessHorizontalSpace = true;
        nameTextGridData.minimumWidth = 20;
        nameTextGridData.horizontalAlignment = 4;
        nameTextGridData.verticalAlignment = 4;
        this.nameText.setLayoutData((Object)nameTextGridData);
        Label descLabel = new Label(contents, 0);
        descLabel.setText("Description");
        GridData descLabelGridData = new GridData();
        descLabelGridData.horizontalAlignment = 4;
        descLabelGridData.verticalAlignment = 4;
        descLabel.setLayoutData((Object)descLabelGridData);
        this.descText = new Text(contents, 0);
        GridData descTextGridData = new GridData();
        descTextGridData.horizontalAlignment = 4;
        descTextGridData.verticalAlignment = 4;
        descTextGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        descTextGridData.heightHint = Display.getCurrent().getBounds().height / 9;
        this.descText.setLayoutData((Object)descTextGridData);
        return contents;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("New Map Group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okPressed() {
        this.mapGroup = MappingFactory.eINSTANCE.createMapGroup();
        this.mapGroup.setId(this.idText.getText());
        this.mapGroup.setName(this.nameText.getText());
        this.mapGroup.setDescription(this.descText.getText());
        try {
            CDOTransaction cDOTransaction = this.transactionGroup;
            synchronized (cDOTransaction) {
                CDOResource mappingResource = this.transactionGroup.getResource(this.sPath);
                this.mapModel = (MapModel)mappingResource.getContents().get(0);
                this.mapModel.getMapGroupModel().add((Object)this.mapGroup);
                mappingResource.save(this.options);
                this.transactionGroup.commit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ConcurrentAccessException e) {
            e.printStackTrace();
            this.transactionGroup.rollback();
        }
        catch (CommitException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    public Boolean getResult() {
        return this.bcheck;
    }
}

