/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.test;

import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactRel;
import org.eclipse.opencert.evm.evidspec.evidence.EvidenceFactory;
import org.eclipse.opencert.storage.cdo.StandaloneCDOAccessor;
import org.eclipse.opencert.storage.cdo.executors.SimpleInTransactionExecutor;

public class EventsTester {
    public static void main(String[] args) {
        int id = 1;
        EventsTester.createArtefact(id);
        EventsTester.updateArtefact(id);
        EventsTester.deleteArtefact(id);
        EventsTester.createArtefactRel(id);
        EventsTester.updateArtefactRel(id);
        EventsTester.deleteArtefactRel(id);
    }

    private static void createArtefact(final int artefactId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: creating artefact...");
                Resource resource = StandaloneCDOAccessor.getDefaultResource(cdoTransaction);
                Artefact artefact = EvidenceFactory.eINSTANCE.createArtefact();
                artefact.setDescription("description_" + artefactId);
                artefact.setId(String.valueOf(artefactId));
                artefact.setName("name_" + artefactId);
                artefact.setVersionID(String.valueOf(1));
                artefact.setChanges("First_artefact_version");
                artefact.setIsLastVersion(true);
                resource.getContents().add((Object)artefact);
                cdoTransaction.setCommitComment("events test");
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static void updateArtefact(final int artefactId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: updating artefact...");
                CDOQuery cqo = cdoTransaction.createQuery("sql", EventsTester.createArtefactQuery(artefactId));
                Artefact artefact = (Artefact)cqo.getResultValue(Artefact.class);
                artefact.setName(String.valueOf(artefact.getName()) + "_updated_" + 2);
                cdoTransaction.setCommitComment("Changing name of artefact " + artefactId);
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static void deleteArtefact(final int artefactId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: deleting artefact...");
                Resource resource = StandaloneCDOAccessor.getDefaultResource(cdoTransaction);
                CDOQuery cqo = cdoTransaction.createQuery("sql", EventsTester.createArtefactQuery(artefactId));
                Artefact artefact = (Artefact)cqo.getResultValue(Artefact.class);
                resource.getContents().remove((Object)artefact);
                cdoTransaction.setCommitComment("Removing artefact " + artefactId);
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static void createArtefactRel(final int artefactRelId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: Creating artefactrel...");
                Resource resource = StandaloneCDOAccessor.getDefaultResource(cdoTransaction);
                ArtefactRel artefactRel = EvidenceFactory.eINSTANCE.createArtefactRel();
                artefactRel.setDescription("description_" + artefactRelId);
                artefactRel.setId(String.valueOf(artefactRelId));
                artefactRel.setName("name_" + artefactRelId);
                resource.getContents().add((Object)artefactRel);
                cdoTransaction.setCommitComment("events test");
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static void updateArtefactRel(final int artefactRelId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: updating artefactRel...");
                CDOQuery cqo = cdoTransaction.createQuery("sql", EventsTester.createArtefactRelQuery(artefactRelId));
                ArtefactRel artefactRel = (ArtefactRel)cqo.getResultValue(ArtefactRel.class);
                artefactRel.setName(String.valueOf(artefactRel.getName()) + "_updated_" + 2);
                cdoTransaction.setCommitComment("Changing name of artefactRel " + artefactRelId);
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static void deleteArtefactRel(final int artefactRelId) {
        new SimpleInTransactionExecutor(){

            @Override
            public void executeInTransaction(CDOTransaction cdoTransaction) {
                System.out.print("scenario: deleting artefactRel...");
                Resource resource = StandaloneCDOAccessor.getDefaultResource(cdoTransaction);
                CDOQuery cqo = cdoTransaction.createQuery("sql", EventsTester.createArtefactRelQuery(artefactRelId));
                ArtefactRel artefactRel = (ArtefactRel)cqo.getResultValue(ArtefactRel.class);
                resource.getContents().remove((Object)artefactRel);
                cdoTransaction.setCommitComment("Removing artefactRel " + artefactRelId);
                System.out.println("done");
            }
        }.executeReadWriteOperation();
    }

    private static String createArtefactQuery(int artefactId) {
        return "select * from evidence_Artefact where id ilike '" + artefactId + "' and cdo_revised = 0 and cdo_version >= 0";
    }

    private static String createArtefactRelQuery(int artefactRelId) {
        return "select * from evidence_ArtefactRel where id ilike '" + artefactRelId + "' and cdo_revised = 0 and cdo_version >= 0";
    }
}

