/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.postgresql.PostgreSQLAdapter;
import org.eclipse.net4j.internal.db.DataSourceConnectionProvider;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.eclipse.opencert.storage.cdo.messages.OpencertPersistenceMessagesProducer;
import org.eclipse.opencert.storage.cdo.messages.PersistenceEventMessage;
import org.eclipse.opencert.storage.cdo.messages.PersistenceEventType;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.postgresql.ds.PGSimpleDataSource;

public class StandaloneCDOServer {
    private OpencertPersistenceMessagesProducer opencertPersistenceMessagesProducer;
    private static final String TRUE = Boolean.TRUE.toString();
    private OpencertPropertiesReader propertiesReader = OpencertPropertiesReader.getInstance();
    private IRepository repository;
    private final DataSource dataSource = this.createDataSource();

    private DataSource createDataSource() {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setUser(this.propertiesReader.getDbUser());
        dataSource.setPassword(this.propertiesReader.getDbPassword());
        dataSource.setServerName(this.propertiesReader.getDbHost());
        dataSource.setPortNumber(this.propertiesReader.getDbPort());
        dataSource.setDatabaseName(this.propertiesReader.getDbName());
        return dataSource;
    }

    public static void main(String[] args) throws Exception {
        new StandaloneCDOServer();
        System.out.println("Standalone CDO server running...");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StandaloneCDOServer() {
        this.init();
    }

    public void setOpencertPersistenceMessagesProducer(OpencertPersistenceMessagesProducer opencertPersistenceMessagesProducer) {
        this.opencertPersistenceMessagesProducer = opencertPersistenceMessagesProducer;
    }

    private void init() {
        OMPlatform.INSTANCE.setDebugging(false);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        Net4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        TCPUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        String name = "opencert";
        IStore store = this.createStore(name);
        Map<String, String> properties = StandaloneCDOServer.createRepositoryProperties(name);
        this.repository = CDOServerUtil.createRepository((String)name, (IStore)store, properties);
        this.registerCommitHandler();
        CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)this.repository);
        Net4jUtil.getAcceptor((IManagedContainer)IPluginContainer.INSTANCE, (String)"tcp", (String)this.propertiesReader.getCDOServerAddress());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StandaloneCDOServer.this.shutdown();
            }
        });
    }

    private void registerCommitHandler() {
        this.repository.addHandler((IRepository.Handler)new IRepository.WriteAccessHandler(){

            public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor omMonitor) throws RuntimeException {
            }

            /*
             * WARNING - void declaration
             */
            public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor omMonitor) {
                Map detachedObjectTypes;
                InternalCDORevision[] dirtyObjects;
                Object entityPersistenceEventMessage;
                InternalCDORevision[] newObjects = commitContext.getNewObjects();
                if (newObjects.length != 0) {
                    InternalCDORevision[] internalCDORevisionArray = newObjects;
                    int n = newObjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalCDORevision internalCDORevision = internalCDORevisionArray[n2];
                        if (StandaloneCDOServer.this.opencertPersistenceMessagesProducer != null) {
                            entityPersistenceEventMessage = new PersistenceEventMessage(PersistenceEventType.CREATE, internalCDORevision.getEClass(), internalCDORevision.getID());
                            StandaloneCDOServer.this.opencertPersistenceMessagesProducer.send((PersistenceEventMessage)entityPersistenceEventMessage);
                        }
                        ++n2;
                    }
                }
                if ((dirtyObjects = commitContext.getDirtyObjects()).length != 0) {
                    void var7_9;
                    entityPersistenceEventMessage = dirtyObjects;
                    int n3 = dirtyObjects.length;
                    boolean bl = false;
                    while (var7_9 < n3) {
                        InternalCDORevision internalCDORevision = entityPersistenceEventMessage[var7_9];
                        if (StandaloneCDOServer.this.opencertPersistenceMessagesProducer != null) {
                            PersistenceEventMessage entityPersistenceEventMessage2 = new PersistenceEventMessage(PersistenceEventType.UPDATE, internalCDORevision.getEClass(), internalCDORevision.getID());
                            StandaloneCDOServer.this.opencertPersistenceMessagesProducer.send(entityPersistenceEventMessage2);
                        }
                        ++var7_9;
                    }
                }
                if ((detachedObjectTypes = commitContext.getDetachedObjectTypes()) != null && detachedObjectTypes.size() > 0) {
                    for (Map.Entry entry : detachedObjectTypes.entrySet()) {
                        if (StandaloneCDOServer.this.opencertPersistenceMessagesProducer == null) continue;
                        entityPersistenceEventMessage = new PersistenceEventMessage(PersistenceEventType.DELETE, (EClass)entry.getValue(), (CDOID)entry.getKey());
                        StandaloneCDOServer.this.opencertPersistenceMessagesProducer.send((PersistenceEventMessage)entityPersistenceEventMessage);
                    }
                }
            }
        });
    }

    public void shutdown() {
        System.out.println("Shutting down CDO server, please wait...");
        LifecycleUtil.deactivate((Object)this.repository);
        LifecycleUtil.deactivate((Object)IPluginContainer.INSTANCE);
        System.out.println("Clean shutdown of CDO server done.");
    }

    private IStore createStore(String name) {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
        this.applyMappingProperties(mappingStrategy);
        PostgreSQLAdapter dbAdapter = new PostgreSQLAdapter();
        DataSourceConnectionProvider dbConnectionProvider = new DataSourceConnectionProvider(this.dataSource, "postgres");
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    private void applyMappingProperties(IMappingStrategy mappingStrategy) {
        HashMap<String, String> mappingProperties = new HashMap<String, String>();
        mappingProperties.put("qualifiedNames", TRUE);
        mappingStrategy.setProperties(mappingProperties);
    }

    private static Map<String, String> createRepositoryProperties(String name) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", name);
        props.put("supportingAudits", TRUE);
        props.put("supportingBranches", TRUE);
        props.put("optimisticLockingTimeout", "10000");
        return props;
    }
}

