/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;

public class DependencyAdapter
extends AdapterImpl {
    private final ModelsReader modelsMetadata = new ModelsReader();
    private final Set<Resource> dependencies = Sets.newLinkedHashSet();
    private final Set<Resource> dependents = Sets.newLinkedHashSet();

    private DependencyAdapter() {
    }

    public static DependencyAdapter getInstance(Resource resource) {
        DependencyAdapter result = DependencyAdapter.getExistingInstance(resource);
        if (result == null) {
            result = new DependencyAdapter();
            resource.eAdapters().add(Math.min(1, resource.eAdapters().size()), (Object)result);
            result.analyze(resource);
        }
        return result;
    }

    static DependencyAdapter getExistingInstance(Resource resource) {
        DependencyAdapter result = null;
        for (Object next : resource.eAdapters()) {
            if (!(next instanceof DependencyAdapter)) continue;
            result = (DependencyAdapter)((Object)next);
            break;
        }
        return result;
    }

    public Set<Resource> getDependencies() {
        return this.dependencies;
    }

    public static Set<Resource> getDependencies(Resource resource) {
        return DependencyAdapter.getInstance(resource).getDependencies();
    }

    public Set<Resource> getDependents() {
        return this.dependents;
    }

    public static Set<Resource> getDependents(Resource resource) {
        return DependencyAdapter.getInstance(resource).getDependents();
    }

    private void analyze(Resource resource) {
        if (resource.getContents().isEmpty() && DependencyAdapter.isDIResource(resource)) {
            for (Resource next : this.getImplicitComponents(resource)) {
                if (!this.isUserModelResource(next.getURI())) continue;
                this.addDependency(next);
            }
        } else {
            TreeIterator iter = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next instanceof EAnnotation) {
                    iter.prune();
                    continue;
                }
                for (EObject xref : next.eCrossReferences()) {
                    Resource xrefRes = xref.eResource();
                    if (xrefRes == null || !this.isUserModelResource(xrefRes.getURI())) continue;
                    this.addDependency(xrefRes);
                }
            }
        }
    }

    private Resource getResource() {
        return (Resource)this.getTarget();
    }

    void addDependency(Resource resource) {
        Resource self = this.getResource();
        if (resource != self && this.dependencies.add(resource)) {
            DependencyAdapter.getInstance(resource).addDependent(self);
        }
    }

    private void addDependent(Resource resource) {
        if (resource != this.getResource()) {
            this.dependents.add(resource);
        }
    }

    boolean isUserModelResource(URI uri) {
        boolean result;
        ModelSet modelSet = this.getModelSet();
        boolean bl = modelSet != null ? modelSet.isUserModelResource(uri) : (result = uri.isPlatformResource() || uri.isFile() || CDOUtils.isCDOURI(uri));
        return result && !uri.isArchive();
    }

    private ModelSet getModelSet() {
        return CDOUtils.adapt(this.getResource().getResourceSet(), ModelSet.class);
    }

    private Iterable<Resource> getImplicitComponents(Resource diResource) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        ResourceSet rset = diResource.getResourceSet();
        URIConverter converter = rset.getURIConverter();
        for (URI next : this.modelsMetadata.getKnownModelURIs(diResource.getURI())) {
            if (next.equals(diResource.getURI()) || !converter.exists(next, null)) continue;
            try {
                result.add(rset.getResource(next, true));
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in loading component of Papyrus model.", (Throwable)e);
            }
        }
        return result;
    }

    public static boolean isDIResource(Resource resource) {
        boolean result = false;
        result = resource.getContents().isEmpty() ? "di".equals(resource.getURI().fileExtension()) : DiUtils.lookupSashWindowsMngr((Resource)resource) != null;
        return result;
    }

    public static Resource getDIResource(Resource resource) {
        Resource result = null;
        if (DependencyAdapter.isDIResource(resource)) {
            result = resource;
        } else {
            Resource di;
            ResourceSet rset = resource.getResourceSet();
            URI uri = resource.getURI().trimFileExtension().appendFileExtension("di");
            if (rset.getURIConverter().exists(uri, null) && (di = rset.getResource(uri, true)) != null && DependencyAdapter.isDIResource(di)) {
                result = di;
            }
        }
        return result;
    }
}

