/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.controlmode;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.ref.Interner;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;

public class CDOProxyManager {
    private static final String URI_SCHEME = "cdo.checkout";
    private final ResourceSet resourceSet;
    private final ProxyInterner proxies = new ProxyInterner();

    public CDOProxyManager(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public EObject getProxy(URI proxyURI) {
        return this.proxies.intern(proxyURI);
    }

    protected InternalEObject createProxy(URI uri) {
        InternalEObject result = null;
        CDOID cdoid = CDOIDUtil.read((String)uri.fragment());
        long oid = CDOIDUtil.getLong((CDOID)cdoid);
        CDOClassifierRef typeRef = CDOIDUtil.getClassifierRef((CDOID)cdoid);
        EClassifier resolvedType = typeRef.resolve(this.resourceSet.getPackageRegistry());
        if (resolvedType instanceof EClass) {
            EClass actualType = (EClass)resolvedType;
            result = (InternalEObject)EcoreUtil.create((EClass)actualType);
            StringBuilder fragment = new StringBuilder();
            CDOIDUtil.write((StringBuilder)fragment, (CDOID)CDOIDUtil.createLong((long)oid));
            result.eSetProxyURI(uri.trimFragment().appendFragment(fragment.toString()));
        }
        return result;
    }

    public static boolean isCDOProxyURI(URI uri) {
        boolean result;
        boolean bl = result = uri.hasFragment() && URI_SCHEME.equals(uri.scheme());
        if (result) {
            CDOID oid = CDOIDUtil.read((String)uri.fragment());
            result = oid instanceof CDOClassifierRef.Provider;
        }
        return result;
    }

    public static String createPapyrusCDOURI(EObject object) {
        return CDOProxyManager.createPapyrusCDOURI(object.eResource().getURI(), object);
    }

    public static String createPapyrusCDOURI(URI resourceURI, EObject object) {
        long oid = CDOIDUtil.getLong((CDOID)CDOUtils.getCDOID(object));
        CDOClassifierRef typeRef = new CDOClassifierRef((EClassifier)object.eClass());
        CDOID oidWithTypeRef = CDOIDUtil.createLongWithClassifier((long)oid, (CDOClassifierRef)typeRef);
        StringBuilder result = new StringBuilder();
        result.append(resourceURI);
        result.append('#');
        CDOIDUtil.write((StringBuilder)result, (CDOID)oidWithTypeRef);
        return result.toString();
    }

    public static String extractOIDFragment(URI proxyURI) {
        String result = null;
        CDOID oid = CDOIDUtil.read((String)proxyURI.fragment());
        if (oid.isObject()) {
            StringBuilder buf = new StringBuilder();
            CDOIDUtil.write((StringBuilder)buf, (CDOID)CDOIDUtil.createLong((long)CDOIDUtil.getLong((CDOID)oid)));
            result = buf.toString();
        }
        return result;
    }

    private final class ProxyInterner
    extends Interner<InternalEObject> {
        private ProxyInterner() {
        }

        public synchronized InternalEObject intern(URI proxyURI) {
            InternalEObject result = null;
            long oid = CDOIDUtil.getLong((CDOID)CDOIDUtil.read((String)proxyURI.fragment()));
            int hashCode = this.hashCode(oid);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null && result == null) {
                result = (InternalEObject)entry.get();
                if (result != null && this.getOID(result) != oid) {
                    result = null;
                }
                entry = entry.getNextEntry();
            }
            if (result == null) {
                result = CDOProxyManager.this.createProxy(proxyURI);
                this.addEntry(this.createEntry(result, hashCode));
            }
            return result;
        }

        private long getOID(InternalEObject object) {
            long result = object.eIsProxy() ? CDOIDUtil.getLong((CDOID)CDOIDUtil.read((String)object.eProxyURI().fragment())) : CDOIDUtil.getLong((CDOID)CDOUtils.getCDOID((EObject)object));
            return result;
        }

        protected int hashCode(InternalEObject proxy) {
            return this.hashCode(this.getOID(proxy));
        }

        int hashCode(long oid) {
            return (int)(oid & 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

