/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AreaUnitKind implements Enumerator
{
    MM2(0, "mm2", "mm2"),
    UM2(1, "um2", "um2");

    public static final int MM2_VALUE = 0;
    public static final int UM2_VALUE = 1;
    private static final AreaUnitKind[] VALUES_ARRAY;
    public static final List<AreaUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AreaUnitKind[]{MM2, UM2};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AreaUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AreaUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AreaUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AreaUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AreaUnitKind get(int value) {
        switch (value) {
            case 0: {
                return MM2;
            }
            case 1: {
                return UM2;
            }
        }
        return null;
    }

    private AreaUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

