/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.opencert.apm.baseline.baseline.diagram.navigator.BaselineAbstractNavigatorItem;
import org.eclipse.opencert.apm.baseline.baseline.diagram.navigator.BaselineNavigatorGroup;
import org.eclipse.opencert.apm.baseline.baseline.diagram.navigator.BaselineNavigatorItem;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineVisualIDRegistry;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.Messages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class BaselineNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public BaselineNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (BaselineNavigatorContentProvider.this.myViewer != null) {
                    BaselineNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                BaselineNavigatorContentProvider.this.unloadAllResources();
                BaselineNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                BaselineNavigatorContentProvider.this.unloadAllResources();
                BaselineNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                BaselineNavigatorContentProvider.this.unloadAllResources();
                BaselineNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        View view;
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList<BaselineNavigatorItem> result = new ArrayList<BaselineNavigatorItem>();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType(topViews, "Baseline"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof BaselineNavigatorGroup) {
            BaselineNavigatorGroup group = (BaselineNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof BaselineNavigatorItem) {
            BaselineNavigatorItem navigatorItem = (BaselineNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        if (parentElement instanceof IAdaptable && (view = (View)((IAdaptable)parentElement).getAdapter(View.class)) != null) {
            return this.getViewChildren(view, parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (BaselineVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                LinkedList<BaselineAbstractNavigatorItem> result = new LinkedList<BaselineAbstractNavigatorItem>();
                result.addAll(this.getForeignShortcuts((Diagram)view, parentElement));
                Diagram sv = (Diagram)view;
                BaselineNavigatorGroup links = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseFramework_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4002));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4003));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4004));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2001: {
                LinkedList<BaselineAbstractNavigatorItem> result = new LinkedList<BaselineAbstractNavigatorItem>();
                Node sv = (Node)view;
                BaselineNavigatorGroup outgoinglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivity_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup incominglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivity_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(7001));
                connectedViews = this.getChildrenByType(connectedViews, BaselineVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2002: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Node sv = (Node)view;
                BaselineNavigatorGroup incominglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseArtefact_2002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2003: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Node sv = (Node)view;
                BaselineNavigatorGroup incominglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseRole_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3001: {
                LinkedList<BaselineAbstractNavigatorItem> result = new LinkedList<BaselineAbstractNavigatorItem>();
                Node sv = (Node)view;
                BaselineNavigatorGroup outgoinglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivity_3001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup incominglinks = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivity_3001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, BaselineVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 4001: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Edge sv = (Edge)view;
                BaselineNavigatorGroup target = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityRequiredArtefact_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup source = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityRequiredArtefact_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4002: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Edge sv = (Edge)view;
                BaselineNavigatorGroup target = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityProducedArtefact_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup source = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityProducedArtefact_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4003: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Edge sv = (Edge)view;
                BaselineNavigatorGroup target = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityPrecedingActivity_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup source = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityPrecedingActivity_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(3001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4004: {
                LinkedList<BaselineNavigatorGroup> result = new LinkedList<BaselineNavigatorGroup>();
                Edge sv = (Edge)view;
                BaselineNavigatorGroup target = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityRole_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                BaselineNavigatorGroup source = new BaselineNavigatorGroup(Messages.NavigatorGroupName_BaseActivityRole_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), BaselineVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Baseline".equals(BaselineVisualIDRegistry.getModelID(view));
    }

    private Collection<BaselineNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<BaselineNavigatorItem> result = new ArrayList<BaselineNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new BaselineNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    private Collection<BaselineNavigatorItem> getForeignShortcuts(Diagram diagram, Object parent) {
        LinkedList<View> result = new LinkedList<View>();
        for (View nextView : diagram.getChildren()) {
            if (this.isOwnView(nextView) || nextView.getEAnnotation("Shortcut") == null) continue;
            result.add(nextView);
        }
        return this.createNavigatorItems(result, parent, false);
    }

    public Object getParent(Object element) {
        if (element instanceof BaselineAbstractNavigatorItem) {
            BaselineAbstractNavigatorItem abstractNavigatorItem = (BaselineAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

