/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.customization.properties.generation.wizard.SelectFieldsPage;
import org.eclipse.papyrus.customization.properties.providers.ContextLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.swt.graphics.Image;

public class DataContextPropertiesLabelProvider
extends StyledCellLabelProvider {
    private final SelectFieldsPage selectFieldsPage;
    private final ILabelProvider labelProvider;

    public DataContextPropertiesLabelProvider(SelectFieldsPage selectFieldsPage) {
        this.selectFieldsPage = selectFieldsPage;
        this.labelProvider = new ContextLabelProvider();
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex();
        StyledString styleText = this.getStyledText(element, columnIndex);
        cell.setText(styleText.getString());
        cell.setStyleRanges(styleText.getStyleRanges());
        cell.setImage(this.getImage(element, columnIndex));
    }

    protected StyledString getStyledText(Object element, int columnIndex) {
        EObject eObject;
        String text = this.getText(element, columnIndex);
        if (columnIndex == this.selectFieldsPage.fieldColumn && !((eObject = EMFHelper.getEObject((Object)element)) instanceof Property)) {
            StyledString styledString = new StyledString(text, StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        return new StyledString(text);
    }

    protected String getText(Object element, int columnIndex) {
        EObject eObject;
        if (columnIndex == this.selectFieldsPage.fieldColumn) {
            return this.labelProvider.getText(element);
        }
        if (columnIndex == this.selectFieldsPage.descriptionColumn && (eObject = EMFHelper.getEObject((Object)element)) instanceof Property) {
            String description = ((Property)element).getDescription();
            if (description != null) {
                return description.replaceAll("[\n\r]+", "\\\\");
            }
            return "";
        }
        return "";
    }

    protected Image getImage(Object element, int columnIndex) {
        if (columnIndex == this.selectFieldsPage.fieldColumn) {
            return this.labelProvider.getImage(element);
        }
        return null;
    }
}

