/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.KeyValueSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.build.BuildSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class BuildSourcePage
extends KeyValueSourcePage {
    public BuildSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
    }

    @Override
    public ILabelProvider createOutlineLabelProvider() {
        return new BuildLabelProvider();
    }

    @Override
    public ITreeContentProvider createOutlineContentProvider() {
        return new BuildOutlineContentProvider();
    }

    protected IDocumentRange getRangeElement(ITextSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        IBuildModel model = (IBuildModel)this.getInputContext().getModel();
        return this.findBuildNode(model.getBuild().getBuildEntries(), selection.getOffset());
    }

    private BuildEntry findBuildNode(IBuildEntry[] nodes, int offset) {
        int i = 0;
        while (i < nodes.length) {
            BuildEntry node = (BuildEntry)nodes[i];
            if (offset >= node.getOffset() && offset < node.getOffset() + node.getLength()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 1];
        more[0] = "org.eclipse.jdt.ui.preferences.PropertiesFileEditorPreferencePage";
        System.arraycopy(ids, 0, more, 1, ids.length);
        return more;
    }

    @Override
    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((BuildSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    @Override
    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        IBuildModel model = (IBuildModel)this.getInputContext().getModel();
        IBuildEntry[] buildEntries = model.getBuild().getBuildEntries();
        int i = 0;
        while (i < buildEntries.length) {
            IDocumentKey key = (IDocumentKey)buildEntries[i];
            if (offset >= key.getOffset() && offset < key.getOffset() + key.getLength()) {
                return key;
            }
            ++i;
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IHyperlinkDetector.class.equals(adapter)) {
            return (T)new BuildHyperlinkDetector(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void updateSelection(Object object) {
        if (object instanceof IDocumentKey) {
            this.setHighlightRange((IDocumentKey)object);
        } else {
            this.resetHighlightRange();
        }
    }

    @Override
    protected ChangeAwareSourceViewerConfiguration createSourceViewerConfiguration(IColorManager colorManager) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore combinedStore = new ChainedPreferenceStore(new IPreferenceStore[]{store, generalTextStore});
        this.setPreferenceStore((IPreferenceStore)combinedStore);
        return new BuildSourceViewerConfiguration(colorManager, (IPreferenceStore)combinedStore, this);
    }

    class BuildLabelProvider
    extends LabelProvider {
        BuildLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IBuildEntry) {
                return ((IBuildEntry)obj).getName();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IBuildEntry) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            return null;
        }
    }

    class BuildOutlineContentProvider
    implements ITreeContentProvider {
        BuildOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return false;
        }

        public Object getParent(Object child) {
            if (child instanceof IBuildEntry) {
                return ((IBuildEntry)child).getModel();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                IBuildModel model = (IBuildModel)parent;
                IBuild build = model.getBuild();
                return build.getBuildEntries();
            }
            return new Object[0];
        }
    }
}

