/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public final class RefactoringDescriptorImageDescriptor
extends CompositeImageDescriptor {
    public static final int WORKSPACE = 2;
    private final int fFlags;
    private final ImageDescriptor fImage;
    private final Point fSize;

    public RefactoringDescriptorImageDescriptor(ImageDescriptor image, int flags, Point size) {
        this.fImage = image;
        this.fFlags = flags;
        this.fSize = size;
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        if ((this.fFlags & 2) != 0) {
            ImageData data = this.getImageData(RefactoringPluginImages.DESC_OVR_WORKSPACE);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.getImageData(this.fImage), 0, 0);
        this.drawBottomRight();
    }

    public boolean equals(Object object) {
        if (object == null || !RefactoringDescriptorImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        RefactoringDescriptorImageDescriptor other = (RefactoringDescriptorImageDescriptor)((Object)object);
        return this.fImage.equals(other.fImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            RefactoringUIPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    protected Point getSize() {
        return this.fSize;
    }

    public int hashCode() {
        return this.fImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }
}

