/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectHandler
extends AbstractBaseHandler<EObject> {
    private CDOCheckout checkout;

    public AbstractObjectHandler(Boolean multi) {
        super(EObject.class, multi);
    }

    public final CDOCheckout getCheckout() {
        return this.checkout;
    }

    protected boolean updateSelection(ISelection selection) {
        this.checkout = null;
        if (super.updateSelection(selection)) {
            for (EObject eObject : this.elements) {
                CDOCheckout objectCheckout = CDOExplorerUtil.getCheckout((Object)eObject);
                if (objectCheckout == null || !objectCheckout.isOpen()) {
                    this.checkout = null;
                    return false;
                }
                if (this.checkout == null) {
                    this.checkout = objectCheckout;
                    continue;
                }
                if (this.checkout == objectCheckout) continue;
                this.checkout = null;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<EObject> collectElements(ISelection selection) {
        List elements = UIUtil.getElements((ISelection)selection);
        if (elements != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : elements) {
                if (element instanceof CDOElement) {
                    CDOElement checkoutElement = (CDOElement)element;
                    Object[] objectArray = checkoutElement.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        result.add(child);
                        ++n2;
                    }
                    continue;
                }
                result.add(element);
            }
            selection = new StructuredSelection(result);
        }
        return super.collectElements(selection);
    }

    protected void doExecute(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        CDOTransaction transaction = this.checkout.openTransaction();
        try {
            ArrayList<EObject> transactionalElements = new ArrayList<EObject>();
            for (EObject element : this.elements) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EObject transactionalElement = transaction.getObject(element);
                transactionalElements.add(transactionalElement);
            }
            if (this.doExecute(event, transactionalElements, monitor)) {
                transaction.commit(monitor);
            }
        }
        finally {
            transaction.close();
        }
    }

    protected abstract boolean doExecute(ExecutionEvent var1, List<EObject> var2, IProgressMonitor var3);
}

