/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractFilteredContentProvider
implements IGraphicalContentProvider {
    protected StructuredViewer viewer;
    private StringEditor filterPattern;
    private PatternViewerFilter filter;
    public static final String BASE_PATTERN = "*";
    protected boolean showIfHasVisibleParent = false;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            this.updateFilter();
        }
    }

    private void updateFilter() {
        if (this.viewer != null && this.filterPattern != null) {
            this.viewer.setFilters(new ViewerFilter[]{this.filter});
        }
    }

    @Override
    public void createBefore(Composite parent) {
        this.filterPattern = new StringEditor(parent, 0, "Filter : ");
        this.filterPattern.setValidateOnDelay(true);
        this.filterPattern.setValue(BASE_PATTERN);
        this.filter = this.getViewerFilter();
        this.filterPattern.addCommitListener(new ICommitListener(){

            @Override
            public void commit(AbstractEditor editor) {
                AbstractFilteredContentProvider.this.filter.setPattern((String)AbstractFilteredContentProvider.this.filterPattern.getValue());
                AbstractFilteredContentProvider.this.viewer.refresh();
            }
        });
        this.updateFilter();
    }

    @Override
    public void createAfter(Composite parent) {
    }

    protected PatternViewerFilter getViewerFilter() {
        PatternViewerFilter filter = new PatternViewerFilter();
        filter.setStrict(false);
        filter.setPattern(BASE_PATTERN);
        filter.setShowIfHasVisibleParent(this.showIfHasVisibleParent);
        return filter;
    }
}

