/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.clipboard;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CopierFactory
implements Supplier<EcoreUtil.Copier> {
    private static List<BiPredicate<? super EReference, ? super EObject>> referenceFilters = new CopyOnWriteArrayList<BiPredicate<? super EReference, ? super EObject>>();
    private final ResourceSet resourceSet;
    private final boolean useOriginalReferences;
    @Deprecated
    public static final CopierFactory DEFAULT = new CopierFactory(true);

    @Deprecated
    public CopierFactory(boolean useOriginalReferences) {
        this(null, useOriginalReferences);
    }

    public CopierFactory(ResourceSet resourceSet) {
        this(resourceSet, true);
    }

    public CopierFactory(ResourceSet resourceSet, boolean useOriginalReferences) {
        this.resourceSet = resourceSet;
        this.useOriginalReferences = useOriginalReferences;
    }

    public boolean isUseOriginalReferences() {
        return this.useOriginalReferences;
    }

    @Override
    public EcoreUtil.Copier get() {
        Optional<BiPredicate<? super EReference, ? super EObject>> referenceFilter = this.getReferenceFilter();
        EcoreUtil.Copier result = referenceFilter.map(this::createReferenceFilteringCopier).orElseGet(this::createBasicCopier);
        return result;
    }

    private Optional<BiPredicate<? super EReference, ? super EObject>> getReferenceFilter() {
        return referenceFilters.stream().reduce(BiPredicate::or).map(BiPredicate::negate);
    }

    private EcoreUtil.Copier createReferenceFilteringCopier(BiPredicate<? super EReference, ? super EObject> referencePredicate) {
        return new ReferenceFilteringCopier(true, this.isUseOriginalReferences(), this.getPackageRegistry(), referencePredicate);
    }

    private EcoreUtil.Copier createBasicCopier() {
        return new BasicCopier(true, this.isUseOriginalReferences(), this.getPackageRegistry());
    }

    private EPackage.Registry getPackageRegistry() {
        return this.resourceSet == null ? EPackage.Registry.INSTANCE : this.resourceSet.getPackageRegistry();
    }

    public static void registerReferenceFilter(BiPredicate<? super EReference, ? super EObject> filter) {
        referenceFilters.add(filter);
    }

    private static class BasicCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private final EPackage.Registry packageRegistry;

        BasicCopier(boolean resolveReferences, boolean useOriginalReferences, EPackage.Registry registry) {
            super(resolveReferences, useOriginalReferences);
            this.packageRegistry = registry;
        }

        protected EObject createCopy(EObject eObject) {
            EClass eClass = this.getTarget(eObject);
            EFactory eFactory = this.getEFactory(eClass);
            return eFactory.create(eClass);
        }

        EFactory getEFactory(EClass eClass) {
            EFactory result = this.packageRegistry.getEFactory(eClass.getEPackage().getNsURI());
            if (result == null) {
                result = eClass.getEPackage().getEFactoryInstance();
            }
            return result;
        }
    }

    private static class ReferenceFilteringCopier
    extends BasicCopier {
        private static final long serialVersionUID = 1L;
        private final BiPredicate<? super EReference, ? super EObject> referencePredicate;

        ReferenceFilteringCopier(boolean resolveReferences, boolean useOriginalReferences, EPackage.Registry registry, BiPredicate<? super EReference, ? super EObject> referencePredicate) {
            super(resolveReferences, useOriginalReferences, registry);
            this.referencePredicate = referencePredicate;
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (this.referencePredicate.test((EReference)eReference, (EObject)eObject)) {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }
    }
}

