/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.label;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.opencert.userguidance.label.LabelHighlighter;
import org.eclipse.opencert.userguidance.label.WrappingLabel2;
import org.eclipse.opencert.userguidance.labelparser.tokens.HighlightItem;
import org.eclipse.opencert.userguidance.labelparser.tokens.TextToken;
import org.eclipse.opencert.userguidance.labelparser.tokens.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class Label2
extends Label {
    private static TextLayout layout;

    public Label2() {
        if (layout == null) {
            layout = new TextLayout((Device)Display.getCurrent());
        }
    }

    protected void paintFigure(Graphics graphics) {
        org.eclipse.draw2d.geometry.Rectangle labelBounds = this.getParent().getParent().getBounds();
        org.eclipse.draw2d.geometry.Rectangle parentBounds = new org.eclipse.draw2d.geometry.Rectangle(labelBounds);
        this.getParent().setBounds(parentBounds);
        org.eclipse.draw2d.geometry.Rectangle bounds = new org.eclipse.draw2d.geometry.Rectangle(0, 0, labelBounds.width, labelBounds.height);
        this.setBounds(bounds);
        layout.setWidth(labelBounds.width);
        graphics.pushState();
        boolean isSelected = ((WrappingLabel2)this.getParent().getParent()).isSelected();
        if (isSelected) {
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        graphics.fillRectangle(this.getBounds());
        graphics.popState();
        LabelHighlighter highlighter = new LabelHighlighter(this.getText(), this.getFont(), this.getFont());
        highlighter.calculateHighlighting();
        List<StyleRange> ranges = highlighter.getStyles();
        String compactText = highlighter.getOutputText();
        layout.setText(compactText);
        this.applyStyles(isSelected, ranges);
        Rectangle layoutBounds = layout.getBounds();
        if (layoutBounds.height > labelBounds.height) {
            int lastVisibleLineOffset = layout.getOffset(labelBounds.width, labelBounds.height, new int[1]);
            int lastVisibleLine = layout.getLineIndex(lastVisibleLineOffset);
            Rectangle lastLineBounds = layout.getLineBounds(lastVisibleLine);
            if (lastLineBounds.y + lastLineBounds.height > labelBounds.height) {
                lastVisibleLineOffset = layout.getLineOffsets()[--lastVisibleLine];
            }
            if (lastVisibleLine + 1 < layout.getLineCount()) {
                int offset = layout.getLineOffsets()[lastVisibleLine];
                String prevText = layout.getText().substring(0, offset);
                String nextText = String.valueOf(Label2.getTextFromLine(lastVisibleLine, layout)) + Label2.getTextFromLine(lastVisibleLine + 1, layout);
                int i = nextText.length();
                while (i >= 0) {
                    String test = String.valueOf(nextText.substring(0, i)) + "...";
                    int width = Label2.measureString(test, ranges, offset, layout);
                    if (width < Label2.layout.getBounds().width) {
                        layout.setText(String.valueOf(prevText) + test);
                        this.applyStyles(isSelected, ranges);
                        break;
                    }
                    --i;
                }
            }
        }
        graphics.drawTextLayout(layout, 0, 0);
    }

    public Token getTokenAt(int x, int y) {
        if (this.getBounds().width <= 0) {
            return null;
        }
        layout.setWidth(this.getBounds().width);
        LabelHighlighter highlighter = new LabelHighlighter(this.getText(), this.getFont(), this.getFont());
        highlighter.calculateHighlighting();
        List<StyleRange> ranges = highlighter.getStyles();
        String compactText = highlighter.getOutputText();
        layout.setText(compactText);
        this.applyStyles(false, ranges);
        int cursorPosition = layout.getOffset(x, y, new int[1]);
        List<Token> tokens = highlighter.getTokens();
        int offset = 0;
        int i = 0;
        while (i < highlighter.getTokens().size()) {
            if (tokens.get(i) instanceof HighlightItem) {
                HighlightItem item = (HighlightItem)tokens.get(i);
                String representation = highlighter.getRepresentation(item);
                offset += representation.length();
            } else if (tokens.get(i) instanceof TextToken) {
                TextToken simpleText = (TextToken)tokens.get(i);
                offset += simpleText.getRepresentation().length();
            }
            if (offset > cursorPosition) {
                return tokens.get(i);
            }
            ++i;
        }
        return null;
    }

    private void applyStyles(boolean isSelected, List<StyleRange> ranges) {
        String text = layout.getText();
        for (StyleRange range : ranges) {
            int start = range.start;
            int length = range.length;
            if (start > text.length()) continue;
            if (length > text.length()) {
                length = text.length();
            }
            if (isSelected) {
                range.background = ColorConstants.menuBackgroundSelected;
                range.foreground = ColorConstants.white;
            }
            layout.setStyle((TextStyle)range, start, start + length);
        }
    }

    private static String getTextFromLine(int line, TextLayout layout) {
        int start = layout.getLineOffsets()[line];
        int end = layout.getLineOffsets()[line + 1];
        return layout.getText().substring(start, end);
    }

    private static int measureString(String text, List<StyleRange> ranges, int offset, TextLayout textLayout) {
        TextLayout lineLayout = new TextLayout(textLayout.getDevice());
        lineLayout.setText(text);
        for (StyleRange range : ranges) {
            int start = range.start - offset;
            int length = range.length;
            if (start > text.length()) continue;
            if (start < 0) {
                length += start;
                start = 0;
            }
            if (length > text.length()) {
                length = text.length();
            }
            lineLayout.setStyle((TextStyle)range, start, start + length);
        }
        return lineLayout.getBounds().width;
    }
}

