/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.celleditor;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.opencert.userguidance.StyledText2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class StyledTextCellEditor
extends CellEditor {
    protected StyledText styledText;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public StyledTextCellEditor(Composite parent, int style, EObject eobj, int featureID) {
        super.setStyle(style);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.styledText.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(Composite parent) {
        this.styledText = new StyledText2(parent, this.getStyle());
        this.styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StyledTextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StyledTextCellEditor.this.keyReleaseOccured(e);
                if (StyledTextCellEditor.this.getControl() == null || StyledTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                StyledTextCellEditor.this.checkSelection();
                StyledTextCellEditor.this.checkDeleteable();
                StyledTextCellEditor.this.checkSelectable();
            }
        });
        this.styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StyledTextCellEditor.this.checkSelection();
                StyledTextCellEditor.this.checkDeleteable();
                StyledTextCellEditor.this.checkSelectable();
            }
        });
        this.styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    if (Display.getDefault().getActiveShell().getChildren()[0].getToolTipText().equals("org.eclipse.opencert.userguidance.autocomplete.ContentProposalPopup")) {
                        return;
                    }
                }
                catch (Exception exception) {}
                StyledTextCellEditor.this.focusLost();
            }
        });
        this.styledText.setFont(parent.getFont());
        this.styledText.setBackground(parent.getBackground());
        this.styledText.setText("");
        this.styledText.addModifyListener(this.getModifyListener());
        return this.styledText;
    }

    protected Object doGetValue() {
        return this.styledText.getText();
    }

    protected void doSetFocus() {
        if (this.styledText != null) {
            this.styledText.selectAll();
            this.styledText.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.styledText != null && value instanceof String ? 1 : 0) != 0);
        this.styledText.removeModifyListener(this.getModifyListener());
        this.styledText.setText((String)value);
        this.styledText.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.styledText.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = new CellEditor.LayoutData();
        data.minimumWidth = 0;
        return data;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StyledTextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.styledText == null || this.styledText.isDisposed()) {
            return false;
        }
        return this.styledText.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.styledText == null || this.styledText.isDisposed()) {
            return false;
        }
        return this.styledText.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.styledText == null || this.styledText.isDisposed()) {
            return false;
        }
        return this.styledText.getSelectionCount() > 0 || this.styledText.getCaretOffset() < this.styledText.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.styledText != null && !this.styledText.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.styledText != null && !this.styledText.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.styledText == null || this.styledText.isDisposed()) {
            return false;
        }
        return this.styledText.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.styledText != null && !this.styledText.isDisposed() && (this.styledText.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.styledText.copy();
    }

    public void performCut() {
        this.styledText.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.styledText.getSelectionCount() > 0) {
            this.styledText.insert("");
        } else {
            int pos = this.styledText.getCaretOffset();
            if (pos < this.styledText.getCharCount()) {
                this.styledText.setSelection(pos, pos + 1);
                this.styledText.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.styledText.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.styledText.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return ((Object)((Object)this)).getClass() != StyledTextCellEditor.class;
    }
}

