/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ILinkMappingHelper;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.internalblock.dnd.helper.CustomLinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CustomDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    private ConnectorUtils utils = new ConnectorUtils();

    public CustomDragDropEditPolicy() {
        super((ILinkMappingHelper)new CustomLinkMappingHelper());
        this.registry = new CustomGraphicalTypeRegistry();
    }

    protected Set<String> getSpecificDropBehaviorTypes() {
        HashSet<String> specificDropBehaviorTypes = new HashSet<String>();
        specificDropBehaviorTypes.add("link_uml_connector");
        return specificDropBehaviorTypes;
    }

    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if ("link_uml_connector".equals(edgeType) && droppedEObject instanceof Connector) {
            return this.getConnectorDropCommand(dropRequest, (Connector)droppedEObject, edgeType);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getConnectorDropCommand(DropObjectsRequest dropRequest, Connector droppedEObject, String edgeType) {
        if (droppedEObject.getEnds().size() != 2) {
            return UnexecutableCommand.INSTANCE;
        }
        ConnectorEnd source = (ConnectorEnd)droppedEObject.getEnds().get(0);
        ConnectorEnd target = (ConnectorEnd)droppedEObject.getEnds().get(1);
        Set<View> sourceViews = this.getViewsForConnectorEnd(source);
        Set<View> targetViews = this.getViewsForConnectorEnd(target);
        SemanticAdapter sourceViewAdapter = null;
        SemanticAdapter targetViewAdapter = null;
        if (sourceViews.isEmpty() || targetViews.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        View selectedSourceView = null;
        View selectedTargetView = null;
        for (View sourceView : sourceViews) {
            View targetView = this.getFirstValidTargetViewForSource(sourceView, targetViews, droppedEObject);
            if (targetView == null) continue;
            selectedSourceView = sourceView;
            selectedTargetView = targetView;
            break;
        }
        if (selectedSourceView == null) {
            return UnexecutableCommand.INSTANCE;
        }
        sourceViewAdapter = new SemanticAdapter(null, selectedSourceView);
        if (selectedTargetView == null) {
            return UnexecutableCommand.INSTANCE;
        }
        targetViewAdapter = new SemanticAdapter(null, selectedTargetView);
        SemanticAdapter droppedObjectAdapter = new SemanticAdapter((EObject)droppedEObject, null);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)droppedObjectAdapter, edgeType, this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), edgeType, (IAdaptable)sourceViewAdapter, (IAdaptable)targetViewAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        createConnectionViewCommand.setElement((EObject)droppedEObject);
        return createConnectionViewCommand;
    }

    private View getFirstValidTargetViewForSource(View sourceView, Collection<View> targetViews, Connector droppedConnector) {
        for (View targetView : targetViews) {
            if (!this.isValidTargetViewForSource(sourceView, targetView, droppedConnector)) continue;
            return targetView;
        }
        return null;
    }

    private boolean isValidTargetViewForSource(View sourceView, View targetView, Connector droppedConnector) {
        if (!this.utils.isCrossingEncapsulation(sourceView, targetView)) {
            EList currentTargetConnectorPropertyPath;
            EList currentSourceConnectorPropertyPath;
            List sourceNestedPaths = this.utils.getNestedPropertyPath(sourceView, targetView);
            List targetNestedPaths = this.utils.getNestedPropertyPath(targetView, sourceView);
            ConnectorEnd sourceConnectorEnd = this.utils.getSourceConnectorEnd(droppedConnector);
            NestedConnectorEnd nestedSourceConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)sourceConnectorEnd, NestedConnectorEnd.class);
            if (nestedSourceConnectorEnd != null ? !sourceNestedPaths.equals(currentSourceConnectorPropertyPath = nestedSourceConnectorEnd.getPropertyPath()) : !sourceNestedPaths.isEmpty()) {
                return false;
            }
            ConnectorEnd targetConnectorEnd = this.utils.getTargetConnectorEnd(droppedConnector);
            NestedConnectorEnd nestedTargetConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)targetConnectorEnd, NestedConnectorEnd.class);
            if (nestedTargetConnectorEnd != null ? !targetNestedPaths.equals(currentTargetConnectorPropertyPath = nestedTargetConnectorEnd.getPropertyPath()) : !targetNestedPaths.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    protected Set<View> getViewsForConnectorEnd(ConnectorEnd end) {
        HashSet<View> views = new HashSet<View>();
        View hostView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        View hostDiagram = hostView instanceof Diagram ? hostView : hostView.getDiagram();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection relatedViews = EMFCoreUtil.getReferencers((EObject)end.getRole(), (EReference[])refs);
        for (View currentView : relatedViews) {
            if (currentView.getDiagram() != hostDiagram) continue;
            boolean isInView = false;
            View containerView = currentView;
            while (containerView != null && !(containerView instanceof Diagram)) {
                if (containerView == this.getReferenceViewForConnectorEnd()) {
                    isInView = true;
                }
                containerView = ViewUtil.getContainerView((View)containerView);
            }
            if (!isInView) continue;
            EObject containerElement = ViewUtil.getContainerView((View)currentView).getElement();
            if (end.getPartWithPort() != null) {
                if (containerElement != end.getPartWithPort()) continue;
                views.add(currentView);
                continue;
            }
            if (end.getRole() instanceof Port) {
                Property property;
                if (containerElement instanceof EncapsulatedClassifier) {
                    views.add(currentView);
                    continue;
                }
                if (!(containerElement instanceof Property) || (property = (Property)containerElement).getType() != end.getRole().getOwner()) continue;
                views.add(currentView);
                continue;
            }
            views.add(currentView);
        }
        return views;
    }

    protected View getReferenceViewForConnectorEnd() {
        return ((IGraphicalEditPart)this.getHost()).getNotationView();
    }
}

