/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import java.util.List;
import org.eclipse.papyrus.customization.palette.dialog.BundleIconExplorerDialog;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.Configuration;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.IconDescriptor;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.ToolConfiguration;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationInformationComposite {
    protected Configuration selectedConfiguration;
    protected Text nameText;
    protected Text descriptionText;
    protected Text iconText;
    protected Text referencedText;
    protected List<Profile> appliedProfiles;
    protected Button iconButton;
    protected static final String PLUGIN_PROTOCOL = "platform:/plugin/";

    public Composite createComposite(final Composite parent, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 260;
        data.horizontalIndent = 10;
        composite.setLayoutData((Object)data);
        Label entryInformationLabel = new Label(composite, 0);
        entryInformationLabel.setText(Messages.Local_Palette_Entry_Information);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        entryInformationLabel.setLayoutData((Object)data);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.Local_Palette_Entry_Name);
        data = new GridData(4, 4, false, false);
        nameLabel.setLayoutData((Object)data);
        this.nameText = new Text(composite, 18432);
        data = new GridData(4, 4, true, false);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addFocusListener((FocusListener)new NameFocusListener());
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)data);
        Label referencedLabel = new Label(composite, 0);
        referencedLabel.setText(Messages.Local_Palette_Entry_Reference);
        data = new GridData(4, 1, true, false);
        referencedLabel.setLayoutData((Object)data);
        this.referencedText = new Text(composite, 18440);
        data = new GridData(4, 4, true, false);
        this.referencedText.setLayoutData((Object)data);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.referencedText.setLayoutData((Object)data);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.Local_Palette_Entry_Description);
        data = new GridData(4, 1, true, false);
        descriptionLabel.setLayoutData((Object)data);
        this.descriptionText = new Text(composite, 2112);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.widthHint = 160;
        this.descriptionText.setLayoutData((Object)data);
        this.descriptionText.addFocusListener((FocusListener)new DescriptionFocusListener());
        Label iconLabel = new Label(composite, 0);
        iconLabel.setText(Messages.Local_Palette_Entry_Icon);
        data = new GridData(4, 1, true, false);
        iconLabel.setLayoutData((Object)data);
        this.iconText = new Text(composite, 18432);
        data = new GridData(4, 4, true, false);
        this.iconText.setLayoutData((Object)data);
        this.iconText.addFocusListener((FocusListener)new IconFocusListener());
        this.iconButton = new Button(composite, 0);
        this.iconButton.setText("Select...");
        this.iconButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                BundleIconExplorerDialog dialog = new BundleIconExplorerDialog(parent.getShell(), ConfigurationInformationComposite.this.iconText.getText());
                if (dialog.open() == 0) {
                    Object[] values = dialog.getResult();
                    if (values.length != 1) {
                        Activator.log.error("Waiting one icon path, but found " + values.length, null);
                    } else {
                        ConfigurationInformationComposite.this.iconText.setText(values[0].toString());
                        String bundleId = dialog.getCurrentBundleName();
                        String iconPath = dialog.getIconPath();
                        ConfigurationInformationComposite.this.updateIconInConfiguration(bundleId, iconPath);
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return composite;
    }

    private void updateIconInConfiguration(String bundleId, String iconPath) {
        if (this.selectedConfiguration != null) {
            IconDescriptor descriptor = PaletteconfigurationFactory.eINSTANCE.createIconDescriptor();
            if (bundleId != null && iconPath != null) {
                descriptor.setPluginID(bundleId);
                descriptor.setIconPath(iconPath);
            }
            this.selectedConfiguration.setIcon(descriptor);
        }
    }

    protected void updateNameEntryField() {
        if (this.selectedConfiguration != null) {
            this.nameText.setText(this.selectedConfiguration.getLabel() != null ? this.selectedConfiguration.getLabel() : "");
            this.nameText.setEnabled(true);
        } else {
            this.nameText.setText("");
            this.nameText.setEnabled(false);
        }
    }

    protected void updateReferencedEntryField() {
        if (this.selectedConfiguration instanceof ToolConfiguration) {
            ToolConfiguration toolConfiguration = (ToolConfiguration)this.selectedConfiguration;
        } else {
            this.referencedText.setText("");
            this.referencedText.setEnabled(false);
        }
    }

    protected void updateDescriptionEntryField() {
        if (this.selectedConfiguration != null) {
            this.descriptionText.setText(this.selectedConfiguration.getDescription() != null ? this.selectedConfiguration.getDescription() : "");
            this.descriptionText.setEnabled(true);
        } else {
            this.descriptionText.setText("");
            this.descriptionText.setEnabled(false);
        }
    }

    protected void updateIconEntryField() {
        if (this.selectedConfiguration != null) {
            IconDescriptor descriptor = this.selectedConfiguration.getIcon();
            if (descriptor != null) {
                String iconPath = descriptor.getIconPath();
                String bundleId = descriptor.getPluginID();
                if (iconPath != null && bundleId != null) {
                    this.iconText.setText(PLUGIN_PROTOCOL + bundleId + iconPath);
                }
            }
            this.iconText.setEnabled(true);
        } else {
            this.iconText.setText("");
            this.iconText.setEnabled(true);
        }
    }

    public void setSelectedConfiguration(Configuration configuration) {
        this.selectedConfiguration = configuration;
        this.updateNameEntryField();
        this.updateIconEntryField();
        this.updateReferencedEntryField();
        this.updateDescriptionEntryField();
    }

    protected class DescriptionFocusListener
    implements FocusListener {
        protected DescriptionFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (ConfigurationInformationComposite.this.selectedConfiguration != null) {
                ConfigurationInformationComposite.this.selectedConfiguration.setDescription(ConfigurationInformationComposite.this.descriptionText.getText().trim());
            }
        }
    }

    protected class IconFocusListener
    implements FocusListener {
        protected IconFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            String text = ConfigurationInformationComposite.this.iconText.getText();
            if (ConfigurationInformationComposite.this.selectedConfiguration != null && text != null && !text.equals("")) {
                if (!text.startsWith(ConfigurationInformationComposite.PLUGIN_PROTOCOL)) {
                    return;
                }
                int i = (text = text.substring(ConfigurationInformationComposite.PLUGIN_PROTOCOL.length(), text.length())).indexOf("/");
                if (i < 1) {
                    return;
                }
                String bundlePath = text.substring(0, i);
                String iconPath = text.substring(bundlePath.length(), text.length());
                ConfigurationInformationComposite.this.updateIconInConfiguration(bundlePath, iconPath);
            }
        }
    }

    protected class NameFocusListener
    implements FocusListener {
        protected NameFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (ConfigurationInformationComposite.this.selectedConfiguration != null) {
                ConfigurationInformationComposite.this.selectedConfiguration.setLabel(ConfigurationInformationComposite.this.nameText.getText().trim());
            }
        }
    }
}

