/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.test;

import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactDefinition;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactModel;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactRel;
import org.eclipse.opencert.evm.evidspec.evidence.EvidenceFactory;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.storage.cdo.StandaloneCDOAccessor;
import org.eclipse.opencert.storage.cdo.executors.SimpleInTransactionExecutor;
import org.eclipse.opencert.storage.cdo.test.DataCreationRoutines;

public class ArtefactsImpactStructureCreator {
    public static void main(String[] args) {
        ArtefactsImpactStructureCreator.createComplexImpactStructure();
    }

    private static void createBasicImpactStructure() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                Artefact notImpactingArtefact = DataCreationRoutines.createArtefact((String)"NotImpactingArtefact", (int)1);
                Artefact artefactA = DataCreationRoutines.createArtefact((String)"ArtefactA", (int)1);
                Artefact artefactB = DataCreationRoutines.createArtefact((String)"ArtefactB", (int)2);
                Artefact artefactC = DataCreationRoutines.createArtefact((String)"ArtefactC", (int)3);
                Artefact artefactD = DataCreationRoutines.createArtefact((String)"ArtefactD", (int)4);
                Artefact artefactE = DataCreationRoutines.createArtefact((String)"ArtefactE", (int)5);
                ArtefactRel artefactRelA = DataCreationRoutines.createArtefactRel((String)"ArtefactRelA", (Artefact)artefactB, (Artefact)artefactA, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                ArtefactRel artefactRelB = DataCreationRoutines.createArtefactRel((String)"ArtefactRelB", (Artefact)artefactC, (Artefact)artefactB, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                ArtefactRel artefactRelC = DataCreationRoutines.createArtefactRel((String)"ArtefactRelC", (Artefact)artefactD, (Artefact)artefactC, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.VALIDATE);
                ArtefactRel artefactRelD = DataCreationRoutines.createArtefactRel((String)"ArtefactRelD", (Artefact)artefactE, (Artefact)artefactD, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.VALIDATE);
                resource.getContents().add((Object)notImpactingArtefact);
                resource.getContents().add((Object)artefactA);
                resource.getContents().add((Object)artefactB);
                resource.getContents().add((Object)artefactC);
                resource.getContents().add((Object)artefactD);
                resource.getContents().add((Object)artefactE);
                resource.getContents().add((Object)artefactRelA);
                resource.getContents().add((Object)artefactRelB);
                resource.getContents().add((Object)artefactRelC);
                resource.getContents().add((Object)artefactRelD);
            }
        }.executeReadWriteOperation();
    }

    private static void createImpactStructureThatWillHavePropagationGraphMinimized() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                Artefact artefactAA = DataCreationRoutines.createArtefact((String)"ArtefactAAA", (int)1001);
                Artefact artefactBB = DataCreationRoutines.createArtefact((String)"ArtefactBBB", (int)1002);
                Artefact artefactCC = DataCreationRoutines.createArtefact((String)"ArtefactCCC", (int)1003);
                Artefact artefactXXX = DataCreationRoutines.createArtefact((String)"ArtefactXXX", (int)1004);
                Artefact artefactZZZ = DataCreationRoutines.createArtefact((String)"ArtefactZZZ", (int)1005);
                ArtefactRel artefactRelAA = DataCreationRoutines.createArtefactRel((String)"ArtefactRelAAA", (Artefact)artefactXXX, (Artefact)artefactAA, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                ArtefactRel artefactRelBB = DataCreationRoutines.createArtefactRel((String)"ArtefactRelBBB", (Artefact)artefactXXX, (Artefact)artefactBB, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                ArtefactRel artefactRelCC = DataCreationRoutines.createArtefactRel((String)"ArtefactRelCCC", (Artefact)artefactXXX, (Artefact)artefactCC, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                ArtefactRel artefactRelXXX = DataCreationRoutines.createArtefactRel((String)"ArtefactRelDDD", (Artefact)artefactZZZ, (Artefact)artefactXXX, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                resource.getContents().add((Object)artefactAA);
                resource.getContents().add((Object)artefactBB);
                resource.getContents().add((Object)artefactCC);
                resource.getContents().add((Object)artefactXXX);
                resource.getContents().add((Object)artefactZZZ);
                resource.getContents().add((Object)artefactRelAA);
                resource.getContents().add((Object)artefactRelBB);
                resource.getContents().add((Object)artefactRelCC);
                resource.getContents().add((Object)artefactRelXXX);
            }
        }.executeReadWriteOperation();
    }

    private static void createComplexImpactStructure() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                Artefact rootArtefact = DataCreationRoutines.createArtefact((String)"RootArtefact_test_single", (int)1);
                resource.getContents().add((Object)rootArtefact);
                ArtefactsImpactStructureCreator.createResursively(resource, 1, rootArtefact, 3, "ts");
            }
        }.executeReadWriteOperation();
    }

    private static void createResursively(Resource resource, int level, Artefact localRootArtefact, int maxLevel, String variantPrefix) {
        if (level > maxLevel) {
            return;
        }
        System.out.println("Level: " + level);
        Artefact artefact1 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_1"), (int)1);
        Artefact artefact2 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_2"), (int)2);
        Artefact artefact3 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_3"), (int)3);
        Artefact artefact4 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_4"), (int)4);
        Artefact artefact5 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_5"), (int)5);
        Artefact artefact6 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + level + "_6"), (int)6);
        Artefact artefact21 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_1"), (int)7);
        Artefact artefact22 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_2"), (int)8);
        Artefact artefact23 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_3"), (int)9);
        Artefact artefact24 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_4"), (int)10);
        Artefact artefact25 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_5"), (int)11);
        Artefact artefact26 = DataCreationRoutines.createArtefact((String)(String.valueOf(variantPrefix) + "_Artefact" + (level + 1) + "_6"), (int)12);
        ArtefactRel artefactRelA = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelA_" + level), (Artefact)artefact1, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelB = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelB_" + level), (Artefact)artefact2, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelC = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelC_" + level), (Artefact)artefact3, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.NONE);
        ArtefactRel artefactRelD = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelD_" + level), (Artefact)artefact4, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.NONE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelE = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelE_" + level), (Artefact)artefact5, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.VALIDATE);
        ArtefactRel artefactRelF = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelF_" + level), (Artefact)artefact6, (Artefact)localRootArtefact, (ChangeEffectKind)ChangeEffectKind.VALIDATE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelG = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelG_" + (level + 1)), (Artefact)artefact21, (Artefact)artefact1, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelH = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelH_" + (level + 1)), (Artefact)artefact22, (Artefact)artefact2, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
        ArtefactRel artefactRelI = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelI_" + (level + 1)), (Artefact)artefact23, (Artefact)artefact3, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelJ = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelJ_" + (level + 1)), (Artefact)artefact24, (Artefact)artefact4, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelK = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelK_" + (level + 1)), (Artefact)artefact25, (Artefact)artefact5, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        ArtefactRel artefactRelL = DataCreationRoutines.createArtefactRel((String)(String.valueOf(variantPrefix) + "_ArtefactRelL_" + (level + 1)), (Artefact)artefact26, (Artefact)artefact6, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
        resource.getContents().add((Object)artefact1);
        resource.getContents().add((Object)artefact2);
        resource.getContents().add((Object)artefact3);
        resource.getContents().add((Object)artefact4);
        resource.getContents().add((Object)artefact5);
        resource.getContents().add((Object)artefact6);
        resource.getContents().add((Object)artefact21);
        resource.getContents().add((Object)artefact22);
        resource.getContents().add((Object)artefact23);
        resource.getContents().add((Object)artefact24);
        resource.getContents().add((Object)artefact25);
        resource.getContents().add((Object)artefact26);
        resource.getContents().add((Object)artefactRelA);
        resource.getContents().add((Object)artefactRelB);
        resource.getContents().add((Object)artefactRelC);
        resource.getContents().add((Object)artefactRelD);
        resource.getContents().add((Object)artefactRelE);
        resource.getContents().add((Object)artefactRelF);
        resource.getContents().add((Object)artefactRelG);
        resource.getContents().add((Object)artefactRelH);
        resource.getContents().add((Object)artefactRelI);
        resource.getContents().add((Object)artefactRelJ);
        resource.getContents().add((Object)artefactRelK);
        resource.getContents().add((Object)artefactRelL);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact21, maxLevel, variantPrefix);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact22, maxLevel, variantPrefix);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact23, maxLevel, variantPrefix);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact24, maxLevel, variantPrefix);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact25, maxLevel, variantPrefix);
        ArtefactsImpactStructureCreator.createResursively(resource, level + 2, artefact26, maxLevel, variantPrefix);
    }

    private static void createImpactStructureWithCycle() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                ArtefactModel am = EvidenceFactory.eINSTANCE.createArtefactModel();
                am.setName("ArtefactModel");
                ArtefactDefinition ad = EvidenceFactory.eINSTANCE.createArtefactDefinition();
                ad.setName("ArtefactDef");
                String prefix = "1_Artefact";
                Artefact artefactA = DataCreationRoutines.createArtefact((String)(String.valueOf(prefix) + "A_cycle"), (int)1);
                Artefact artefactB = DataCreationRoutines.createArtefact((String)(String.valueOf(prefix) + "B_cycle"), (int)2);
                Artefact artefactC = DataCreationRoutines.createArtefact((String)(String.valueOf(prefix) + "C_cycle"), (int)3);
                Artefact artefactD = DataCreationRoutines.createArtefact((String)(String.valueOf(prefix) + "D_cycle"), (int)4);
                ArtefactRel artefactRelA = DataCreationRoutines.createArtefactRel((String)(String.valueOf(prefix) + "RelA_cycle"), (Artefact)artefactB, (Artefact)artefactA, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                ArtefactRel artefactRelB = DataCreationRoutines.createArtefactRel((String)(String.valueOf(prefix) + "RelB_cycle"), (Artefact)artefactC, (Artefact)artefactB, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                ArtefactRel artefactRelC = DataCreationRoutines.createArtefactRel((String)(String.valueOf(prefix) + "RelC_cycle"), (Artefact)artefactD, (Artefact)artefactC, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                ArtefactRel artefactRelD = DataCreationRoutines.createArtefactRel((String)(String.valueOf(prefix) + "RelD_cycle"), (Artefact)artefactA, (Artefact)artefactD, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                artefactB.getOwnedRel().add((Object)artefactRelA);
                artefactC.getOwnedRel().add((Object)artefactRelB);
                artefactD.getOwnedRel().add((Object)artefactRelC);
                artefactA.getOwnedRel().add((Object)artefactRelD);
                ad.getArtefact().add((Object)artefactA);
                ad.getArtefact().add((Object)artefactB);
                ad.getArtefact().add((Object)artefactC);
                ad.getArtefact().add((Object)artefactD);
                am.getArtefact().add((Object)ad);
                resource.getContents().add((Object)am);
            }
        }.executeReadWriteOperation();
    }
}

