/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.relations;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefact;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefactRel;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactRel;
import org.eclipse.opencert.impactanalysis.relations.ArtefactRelationType;
import org.eclipse.opencert.impactanalysis.relations.ArtefactToMappedBaseArtefactRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.ArtefactsRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.BaseArtefactMappedToArtefactRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.BaseArtefactsRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.storage.cdo.CDOStorageUtil;

public class ArtefactsRelationImpactFactory {
    public static IArtefactRelationImpact createArtefactsRelationImpact(int recursionDepth, ArtefactRel originalArtefactRel, EventKind impactingEventKind) {
        ChangeEffectKind impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(originalArtefactRel.getModificationEffect(), originalArtefactRel.getRevocationEffect(), impactingEventKind);
        if (impactedChangeEffectKind == null) {
            return null;
        }
        return new ArtefactsRelationImpact(recursionDepth, originalArtefactRel, impactedChangeEffectKind, impactingEventKind);
    }

    public static IArtefactRelationImpact createArtefactsRelationImpact(int recursionDepth, BaseArtefactRel originalBaseArtefactRel, EventKind impactingEventKind) {
        ChangeEffectKind impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(originalBaseArtefactRel.getModificationEffect(), originalBaseArtefactRel.getRevocationEffect(), impactingEventKind);
        if (impactedChangeEffectKind == null) {
            return null;
        }
        return new BaseArtefactsRelationImpact(recursionDepth, originalBaseArtefactRel, impactedChangeEffectKind, impactingEventKind);
    }

    public static IArtefactRelationImpact createEvidenceMappedToBaseArtefactImpact(int recursionDepth, Artefact impactingArtefact, BaseArtefact impactedMappedBaseArtefact, EventKind impactingEventKind, IArtefactRelationImpact sourceArtefactRelationImpact) {
        ChangeEffectKind impactedChangeEffectKind = null;
        if (sourceArtefactRelationImpact == null) {
            impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(ChangeEffectKind.MODIFY, ChangeEffectKind.REVOKE, impactingEventKind);
        } else {
            if (ArtefactRelationType.DIRECT_EVIDENCE_RELATION.equals((Object)sourceArtefactRelationImpact.getArtefactRelationType())) {
                ArtefactsRelationImpact artefactRelationImpactToMimic = (ArtefactsRelationImpact)sourceArtefactRelationImpact;
                impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(artefactRelationImpactToMimic.getImpactingArtefactRelModificationEffect(), artefactRelationImpactToMimic.getImpactingArtefactRelRevocationEffect(), impactingEventKind);
            }
            if (ArtefactRelationType.BASELINE_TO_EVIDENCE_VIA_MAP_RELATION.equals((Object)sourceArtefactRelationImpact.getArtefactRelationType())) {
                BaseArtefactMappedToArtefactRelationImpact baseArtefactMappedToArtefactRelationImpact = (BaseArtefactMappedToArtefactRelationImpact)sourceArtefactRelationImpact;
                Long impactedMappedArtefactCDOId = CDOStorageUtil.getCDOId((EObject)impactedMappedBaseArtefact);
                Long originallyImpactingBaseArtefactCDOId = baseArtefactMappedToArtefactRelationImpact.getImpactingArtefactCDOId();
                if (impactedMappedArtefactCDOId != null && impactedMappedArtefactCDOId.equals(originallyImpactingBaseArtefactCDOId)) {
                    return null;
                }
                impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(baseArtefactMappedToArtefactRelationImpact.getImpactingBaseArtefactRelModificationEffect(), baseArtefactMappedToArtefactRelationImpact.getImpactingBaseArtefactRelRevocationEffect(), impactingEventKind);
            }
        }
        if (impactedChangeEffectKind == null) {
            return null;
        }
        ArtefactToMappedBaseArtefactRelationImpact artefactToMappedBaseArtefactRelationImpact = new ArtefactToMappedBaseArtefactRelationImpact(recursionDepth, impactingArtefact, impactedMappedBaseArtefact, impactedChangeEffectKind, impactingEventKind);
        return artefactToMappedBaseArtefactRelationImpact;
    }

    public static IArtefactRelationImpact createBaseArtefactMappedToEvidenceImpact(int recursionDepth, BaseArtefact baseArtefact, Artefact mappedArtefact, EventKind impactingEventKind, IArtefactRelationImpact sourceArtefactRelationImpact) {
        ChangeEffectKind impactingBaseArtefactRelRevocationEffect;
        if (sourceArtefactRelationImpact == null || !ArtefactRelationType.DIRECT_BASELINE_RELATION.equals((Object)sourceArtefactRelationImpact.getArtefactRelationType())) {
            throw new IllegalStateException("Impact analysis from Baseline to Evidence can performed only in a chain in which previous relation was of type" + (Object)((Object)ArtefactRelationType.DIRECT_BASELINE_RELATION) + ". Offending BaseArtefact: " + baseArtefact);
        }
        BaseArtefactsRelationImpact baseArtefactsRelationImpact = (BaseArtefactsRelationImpact)sourceArtefactRelationImpact;
        ChangeEffectKind impactingBaseArtefactRelModificationEffect = baseArtefactsRelationImpact.getImpactingBaseArtefactRelModificationEffect();
        ChangeEffectKind impactedChangeEffectKind = ArtefactsRelationImpactFactory.selectArtefactRelChangeEffectByEventKind(impactingBaseArtefactRelModificationEffect, impactingBaseArtefactRelRevocationEffect = baseArtefactsRelationImpact.getImpactingBaseArtefactRelRevocationEffect(), impactingEventKind);
        if (impactedChangeEffectKind == null) {
            return null;
        }
        return new BaseArtefactMappedToArtefactRelationImpact(recursionDepth, impactingBaseArtefactRelModificationEffect, impactingBaseArtefactRelRevocationEffect, baseArtefact, mappedArtefact, impactedChangeEffectKind, impactingEventKind);
    }

    private static ChangeEffectKind selectArtefactRelChangeEffectByEventKind(ChangeEffectKind modificationChangeEffectKind, ChangeEffectKind revocationChangeEffectKind, EventKind impactingEventKind) {
        if (EventKind.MODIFICATION.equals((Object)impactingEventKind)) {
            return modificationChangeEffectKind;
        }
        if (EventKind.REVOCATION.equals((Object)impactingEventKind)) {
            return revocationChangeEffectKind;
        }
        return null;
    }
}

