/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.eventcreators;

import java.util.Date;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceAssetEvent;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceassetFactory;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceassetPackage;
import org.eclipse.opencert.impactanalysis.eventcreators.IChangeDrivenEventsCreator;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;

public abstract class AbstractChangeDrivenEventsCreator
implements IChangeDrivenEventsCreator {
    @Override
    public AssuranceAssetEvent produceEvent(IArtefactRelationImpact artefactRelationImpact, ChangeEffectKind impactedChangeEffectKind) {
        AssuranceassetPackage aaPackage = AssuranceassetPackage.eINSTANCE;
        AssuranceassetFactory aaFactory = aaPackage.getAssuranceassetFactory();
        AssuranceAssetEvent assuranceAssetEvent = aaFactory.createAssuranceAssetEvent();
        assuranceAssetEvent.setType(this.getEventKind());
        assuranceAssetEvent.setTime(this.getAssuranceAssetEventDate());
        assuranceAssetEvent.setName("Event created by Impact Analysis");
        String userFriendlyImpactingArtefactName = artefactRelationImpact.getUserFriendlyImpactingArtefactName();
        String userFriendlyRelationName = artefactRelationImpact.getUserFriendlyRelationName();
        assuranceAssetEvent.setDescription("This event was added on " + new Date() + " as a result of impact propagated from artefact \"" + userFriendlyImpactingArtefactName + "\" sending event \"" + artefactRelationImpact.getImpactingEventKind() + "\" via relation \"" + userFriendlyRelationName + "\" with change effect kind: \"" + impactedChangeEffectKind + "\"");
        return assuranceAssetEvent;
    }

    protected abstract Date getAssuranceAssetEventDate();
}

