/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class PortDropHelper
extends ElementHelper {
    public PortDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public ICommand getDropPortOnPart(DropObjectsRequest request, GraphicalEditPart host) {
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidPort(droppedEObject, this.getHostEObject(host))) {
            return new CommandProxy((Command)UnexecutableCommand.INSTANCE);
        }
        return this.getDropPortOnPart((Port)droppedEObject, request.getLocation().getCopy(), host);
    }

    public ICommand getDropPortOnPart(Port droppedPort, Point location, GraphicalEditPart host) {
        if (!this.isValidPort(droppedPort, this.getHostEObject(host))) {
            return new CommandProxy((Command)UnexecutableCommand.INSTANCE);
        }
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)droppedPort), Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(location);
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        return new CommandProxyWithResult(viewCreateCommand, (Object)descriptor);
    }

    private boolean isValidPort(Object object, EObject dropTarget) {
        boolean isValid = false;
        if (object != null && object instanceof Port) {
            Type targetType;
            Port port = (Port)object;
            if (dropTarget != null && dropTarget instanceof TypedElement && ((TypedElement)dropTarget).getType() != null && (targetType = ((TypedElement)dropTarget).getType()) instanceof Classifier) {
                Classifier classifier = (Classifier)targetType;
                isValid = classifier.getAllAttributes().contains((Object)port);
            }
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

