/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;

public interface IFeatureSetterAspectAction {
    public EStructuralFeature[] getAllImpactedFeatures();

    public static class IFeatureSetterAspectActionUtil {
        public static Set<EStructuralFeature> getAllImpactedFeatures(Request request) {
            return IFeatureSetterAspectActionUtil.getAllImpactedFeatures(request.getExtendedData());
        }

        public static Set<EStructuralFeature> getAllImpactedFeatures(Map map) {
            HashSet<EStructuralFeature> result = new HashSet<EStructuralFeature>();
            List<IAspectAction> aspectActions = AspectUnspecifiedTypeCreationTool.getAspectActions(map);
            if (aspectActions != null) {
                for (IAspectAction a : aspectActions) {
                    if (!(a instanceof IFeatureSetterAspectAction)) continue;
                    IFeatureSetterAspectAction featureSetter = (IFeatureSetterAspectAction)((Object)a);
                    result.addAll(Arrays.asList(featureSetter.getAllImpactedFeatures()));
                }
            }
            return result;
        }

        public static Set<EStructuralFeature> getAllImpactedFeatures(IEditCommandRequest request) {
            return IFeatureSetterAspectActionUtil.getAllImpactedFeatures(request.getParameters());
        }

        public static boolean areFeaturesManaged(Request request, EStructuralFeature ... features) {
            return request != null && IFeatureSetterAspectActionUtil.areFeaturesManaged(request.getExtendedData(), features);
        }

        public static boolean areFeaturesManaged(IEditCommandRequest request, EStructuralFeature features) {
            return request != null && IFeatureSetterAspectActionUtil.areFeaturesManaged(request.getParameters(), features);
        }

        private static boolean areFeaturesManaged(Map map, EStructuralFeature ... feature) {
            Set<EStructuralFeature> impacted = IFeatureSetterAspectActionUtil.getAllImpactedFeatures(map);
            EStructuralFeature[] eStructuralFeatureArray = feature;
            int n = feature.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature f = eStructuralFeatureArray[n2];
                if (!impacted.contains(f)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

