/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedAdapter;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.ConnectionToolPreferences;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AspectUnspecifiedTypeConnectionTool
extends UnspecifiedTypeConnectionTool {
    private static final int STATE_CONNECTION_WAITING_END = 65;
    protected List<IPostAction> postActions = new ArrayList<IPostAction>();
    protected List<IPreAction> preActions = new ArrayList<IPreAction>();
    private final List<IElementType> elementTypes;

    public AspectUnspecifiedTypeConnectionTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.elementTypes = elementTypes;
    }

    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    protected boolean handleButtonUpOneClick(int button) {
        return super.handleButtonUp(button);
    }

    public void setSourceEditPart(EditPart editPart) {
        if (!ConnectionToolPreferences.instance.isInSingleClickMode()) {
            this.lockTargetEditPart(editPart);
            this.setViewer(editPart.getViewer());
            this.handleButtonDown(1);
            this.unlockTargetEditPart();
            this.handleButtonUp(1);
        }
    }

    protected boolean handleButtonUpTwoClicks(int button) {
        this.setCtrlKeyDown(this.getCurrentInput().isControlKeyDown());
        if (this.isInState(64)) {
            this.setState(65);
            return false;
        }
        if (this.isInState(65)) {
            this.handleCreateConnection();
        }
        this.setState(0x40000000);
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (ConnectionToolPreferences.instance.isInSingleClickMode()) {
            return this.handleButtonUpOneClick(button);
        }
        return this.handleButtonUpTwoClicks(button);
    }

    protected void createConnection() {
        List selectedEditParts = this.getCurrentViewer().getSelectedEditParts();
        ArrayList<View> eobjects = new ArrayList<View>();
        ArrayList<1> listeners = new ArrayList<1>();
        DiagramEventBroker eventBroker = null;
        final EditPartViewer viewer = this.getCurrentViewer();
        if (!selectedEditParts.isEmpty()) {
            IGraphicalEditPart targetEditPart = (IGraphicalEditPart)selectedEditParts.get(selectedEditParts.size() - 1);
            boolean done = false;
            int i = 0;
            while (i < selectedEditParts.size()) {
                IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)selectedEditParts.get(i);
                if (i != 0 && sourceEditPart == targetEditPart || !(sourceEditPart instanceof NodeEditPart) || !(targetEditPart instanceof NodeEditPart)) break;
                CreateConnectionRequest connectionRequest = this.createTargetRequest();
                Point[] newLocation = LayoutUtils.getLinkAnchor(sourceEditPart, targetEditPart);
                connectionRequest.setTargetEditPart((EditPart)sourceEditPart);
                connectionRequest.setType((Object)"connection start");
                connectionRequest.setLocation(newLocation[0]);
                if (sourceEditPart.getCommand((Request)connectionRequest) != null) {
                    Command command;
                    connectionRequest.setSourceEditPart((EditPart)sourceEditPart);
                    connectionRequest.setTargetEditPart((EditPart)targetEditPart);
                    connectionRequest.setType((Object)"connection end");
                    connectionRequest.setLocation(newLocation[1]);
                    this.setTargetRequest((Request)connectionRequest);
                    View eObject = (View)targetEditPart.getAdapter(View.class);
                    NotificationListener listener = null;
                    boolean requiresPostCommitRun = this.requiresPostCommitRun();
                    if (requiresPostCommitRun) {
                        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
                        eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
                        listener = new NotificationListener(){

                            public void notifyChanged(Notification notification) {
                                Object newValue = notification.getNewValue();
                                Map map = viewer.getEditPartRegistry();
                                EditPart editPart = (EditPart)map.get(newValue);
                                for (IPostAction action : AspectUnspecifiedTypeConnectionTool.this.postActions) {
                                    action.runInPostCommit(editPart);
                                }
                            }
                        };
                        if (!done && eventBroker != null) {
                            listeners.add(listener);
                            eobjects.add(eObject);
                            eventBroker.addNotificationListener((EObject)eObject, listener);
                            done = true;
                        }
                    }
                    if ((command = targetEditPart.getCommand((Request)connectionRequest)) != null) {
                        Command completeCommand = this.getCompleteCommand(command);
                        this.setCurrentCommand(completeCommand);
                        this.executeCurrentCommand();
                    }
                    if (requiresPostCommitRun && eventBroker != null) {
                        int ii = 0;
                        while (ii < eobjects.size()) {
                            eventBroker.removeNotificationListener((EObject)eobjects.get(ii), (NotificationListener)listeners.get(ii));
                            ++ii;
                        }
                    }
                    this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues((Command)command));
                }
                ++i;
            }
            this.setAvoidDeactivation(false);
            this.eraseSourceFeedback();
            this.deactivate();
        }
    }

    protected Command getCompleteCommand(Command createConnectionCommand) {
        CompoundCommand compositeCmd = new CompoundCommand("Create Link");
        for (IPreAction preAction : this.preActions) {
            ICommand cmd;
            if (!(this.getTargetRequest() instanceof CreateConnectionRequest)) continue;
            Object sourceModel = ((CreateConnectionRequest)this.getTargetRequest()).getSourceEditPart().getModel();
            Object targetModel = ((CreateConnectionRequest)this.getTargetRequest()).getTargetEditPart().getModel();
            if (!(sourceModel instanceof View) || !(targetModel instanceof View) || (cmd = preAction.getConnectionPreCommand((View)sourceModel, (View)targetModel)) == null) continue;
            compositeCmd.add((Command)new ICommandProxy(cmd));
        }
        compositeCmd.add(createConnectionCommand);
        if (this.getTargetRequest() instanceof CreateRequest) {
            CreateUnspecifiedAdapter viewAdapter = new CreateUnspecifiedAdapter();
            viewAdapter.add((CreateRequest)this.getTargetRequest());
            for (IPostAction action : this.postActions) {
                ICommand cmd = action.getPostCommand((IAdaptable)viewAdapter);
                if (cmd == null) continue;
                compositeCmd.add((Command)new ICommandProxy(cmd));
            }
        }
        return compositeCmd;
    }

    protected boolean handleCreateConnection() {
        Command endCommand;
        this.setAvoidDeactivation(true);
        if (this.getTargetEditPart() == null) {
            return false;
        }
        View eObject = (View)this.getTargetEditPart().getAdapter(View.class);
        DiagramEventBroker eventBroker = null;
        NotificationListener listener = null;
        boolean requiresPostCommitRun = true;
        final EditPartViewer currentViewer = this.getCurrentViewer();
        if (requiresPostCommitRun) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
            eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
            listener = new NotificationListener(){

                public void notifyChanged(Notification notification) {
                    Object newValue = notification.getNewValue();
                    if (currentViewer != null) {
                        EditPart editPart = (EditPart)currentViewer.getEditPartRegistry().get(newValue);
                        for (IPostAction action : AspectUnspecifiedTypeConnectionTool.this.postActions) {
                            action.runInPostCommit(editPart);
                        }
                    }
                }
            };
            if (eventBroker != null) {
                eventBroker.addNotificationListener((EObject)eObject, listener);
            }
        }
        if ((endCommand = this.getCommand()) != null) {
            Command completeCommand = this.getCompleteCommand(endCommand);
            this.setCurrentCommand(completeCommand);
            this.executeCurrentCommand();
        }
        if (requiresPostCommitRun && eventBroker != null) {
            eventBroker.removeNotificationListener((EObject)eObject, listener);
        }
        this.selectAddedObject(currentViewer, DiagramCommandStack.getReturnValues((Command)endCommand));
        this.setAvoidDeactivation(false);
        this.eraseSourceFeedback();
        this.deactivate();
        return true;
    }

    protected boolean requiresPostCommitRun() {
        for (IPostAction action : this.postActions) {
            if (!action.needsPostCommitRun()) continue;
            return true;
        }
        return false;
    }

    protected void applyProperty(Object key, Object value) {
        if ("aspectActions".equals(key)) {
            if (value instanceof NodeList) {
                PaletteUtil.initAspectActions((NodeList)value, this.postActions, this.preActions);
            }
        } else {
            super.applyProperty(key, value);
        }
    }

    protected CreateConnectionRequest createTargetRequest() {
        return new CreateAspectUnspecifiedTypeConnectionRequest(this.getElementTypes(), false, this.getPreferencesHint());
    }

    public class CreateAspectUnspecifiedTypeConnectionRequest
    extends CreateUnspecifiedTypeConnectionRequest {
        private Map<IElementType, CreateConnectionRequest> requests;
        private List newObjectList;
        private boolean useModelingAssistantService;
        private boolean directionReversed;
        private PreferencesHint preferencesHint;

        public CreateAspectUnspecifiedTypeConnectionRequest(List<IElementType> relationshipTypes, boolean useModelingAssistantService, PreferencesHint preferencesHint) {
            super(relationshipTypes, useModelingAssistantService, preferencesHint);
            this.requests = new HashMap<IElementType, CreateConnectionRequest>();
            this.newObjectList = new ArrayList();
            this.directionReversed = false;
            this.useModelingAssistantService = useModelingAssistantService;
            this.preferencesHint = preferencesHint;
            this.createRequests();
        }

        public Object getNewObject() {
            if (this.newObjectList.isEmpty()) {
                if (this.requests.size() == 1) {
                    CreateConnectionRequest createRequest = this.requests.values().iterator().next();
                    if (createRequest instanceof CreateRequest) {
                        this.newObjectList.add(((CreateRequest)createRequest).getNewObject());
                    }
                } else if (this.requests.size() > 1) {
                    CreateUnspecifiedAdapter adapter = new CreateUnspecifiedAdapter();
                    for (CreateConnectionRequest request : this.requests.values()) {
                        if (!(request instanceof CreateRequest)) continue;
                        adapter.add((CreateRequest)request);
                    }
                    ArrayList<CreateUnspecifiedAdapter> newObjects = new ArrayList<CreateUnspecifiedAdapter>();
                    newObjects.add(adapter);
                    return newObjects;
                }
            }
            return this.newObjectList;
        }

        protected void createRequests() {
            for (IElementType elementType : this.getElementTypes()) {
                CreateConnectionViewRequest request = PapyrusCreateViewRequestFactory.getCreateConnectionRequest(elementType, this.getPreferencesHint());
                request.setType(this.getType());
                this.requests.put(elementType, (CreateConnectionRequest)request);
            }
        }

        public CreateRequest getRequestForType(IElementType relationshipType) {
            if (this.requests != null) {
                return (CreateRequest)this.requests.get(relationshipType);
            }
            return null;
        }

        public void addRequest(IElementType relationshipType, Request request) {
            if (this.requests != null && request instanceof CreateConnectionRequest) {
                this.requests.put(relationshipType, (CreateConnectionRequest)request);
            }
        }

        public List getAllRequests() {
            if (this.requests != null) {
                return new ArrayList<CreateConnectionRequest>(this.requests.values());
            }
            return Collections.EMPTY_LIST;
        }

        public void setSourceEditPart(EditPart part) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setSourceEditPart(part);
                }
            }
            super.setSourceEditPart(part);
        }

        public void setTargetEditPart(EditPart part) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setTargetEditPart(part);
                }
            }
            super.setTargetEditPart(part);
        }

        public void setLocation(Point location) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setLocation(location);
                }
            }
            super.setLocation(location);
        }

        public void setType(Object type) {
            if ("connection end".equals(this.getType()) && "connection start".equals(type)) {
                AspectUnspecifiedTypeConnectionTool.this.setAvoidDeactivation(false);
                AspectUnspecifiedTypeConnectionTool.this.eraseSourceFeedback();
                AspectUnspecifiedTypeConnectionTool.this.deactivate();
                AspectUnspecifiedTypeConnectionTool.this.handleFinished();
            }
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setType(type);
                }
            }
            super.setType(type);
        }

        public boolean isDirectionReversed() {
            return this.directionReversed;
        }

        public void setDirectionReversed(boolean directionReversed) {
            this.directionReversed = directionReversed;
        }

        public boolean useModelingAssistantService() {
            return this.useModelingAssistantService;
        }

        protected PreferencesHint getPreferencesHint() {
            return this.preferencesHint;
        }
    }

    public static class PapyrusCreateViewRequestFactory {
        public static CreateViewRequest getCreateShapeRequest(IElementType type, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, ((INotationType)type).getSemanticHint(), preferencesHint);
                return new CreateViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(type)), Node.class, ((IHintedType)type).getSemanticHint(), preferencesHint);
                return new CreateViewAndElementRequest(viewDescriptor);
            }
            return new CreateViewAndElementRequest(type, preferencesHint);
        }

        public static CreateConnectionViewRequest getCreateConnectionRequest(IElementType type, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, ((IHintedType)type).getSemanticHint(), preferencesHint);
                return new CreateConnectionViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                return new CreateConnectionViewAndElementRequest(type, ((IHintedType)type).getSemanticHint(), preferencesHint);
            }
            return new CreateConnectionViewAndElementRequest(type, preferencesHint);
        }

        public static CreateConnectionViewRequest getCreateConnectionRequest(IElementType type, String graphicalHint, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, graphicalHint, preferencesHint);
                return new CreateConnectionViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                return new CreateConnectionViewAndElementRequest(type, graphicalHint, preferencesHint);
            }
            return new CreateConnectionViewAndElementRequest(type, preferencesHint);
        }
    }
}

