/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypePropertyParser
implements IParser,
ISemanticParser {
    private static final String DEFAULT_VALUE = "<UNDEFINED>";

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        if (element instanceof IAdaptable) {
            Element umlElement;
            Property property = (Property)EMFHelper.getEObject((Object)element);
            View view = (View)element.getAdapter(View.class);
            EObject stereotypeApplication = ((View)view.eContainer()).getElement();
            Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
            String result = StereotypeUtil.displayPropertyValue((Stereotype)stereotype, (Property)property, (Element)(umlElement = UMLUtil.getBaseElement((EObject)stereotypeApplication)), (String)"");
            if (result.contains("=")) {
                result = result.substring(property.getName().length() + 1);
                return result;
            }
            return "";
        }
        return DEFAULT_VALUE;
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        if (element instanceof IAdaptable) {
            final Property property = (Property)EMFHelper.getEObject((Object)element);
            View view = (View)element.getAdapter(View.class);
            EObject stereotypeApplication = ((View)view.eContainer()).getElement();
            final Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
            final Element umlElement = UMLUtil.getBaseElement((EObject)stereotypeApplication);
            final Object oldValue = umlElement.getValue(stereotype, property.getName());
            AbstractCommand cmd = new AbstractCommand("AppliedStereotypeProperty"){

                protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    umlElement.setValue(stereotype, property.getName(), oldValue);
                    return null;
                }

                protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    umlElement.setValue(stereotype, property.getName(), (Object)newString);
                    return null;
                }

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    umlElement.setValue(stereotype, property.getName(), (Object)newString);
                    return null;
                }
            };
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
        if (element instanceof IAdaptable) {
            Property property = (Property)EMFHelper.getEObject((Object)element);
            View view = (View)element.getAdapter(View.class);
            if (view != null && property != null) {
                return helper.getStereotypePropertyToDisplay(view, property);
            }
        }
        return DEFAULT_VALUE;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Notification notification = (Notification)event;
            int eventType = notification.getEventType();
            return 32 == eventType || 31 == eventType || 33 == eventType;
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.common", 0, "Papyrus Edition for property of stereotype");
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        return new ArrayList();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object object) {
        if (object instanceof Notification) {
            Notification notification = (Notification)object;
            int eventType = notification.getEventType();
            return 32 == eventType || 31 == eventType || 33 == eventType;
        }
        return false;
    }
}

