/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;

public class AdapterFactoryFactory {
    public static final AdapterFactoryFactory eINSTANCE = new AdapterFactoryFactory();
    private static final String A_FACTORY = "factory";
    private static final String EXT_POINT_FACTORIES = "adapterFactories";
    private static final Log logger = LogFactory.getLog(AdapterFactoryFactory.class);

    private AdapterFactoryFactory() {
    }

    protected AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory result = new ComposedAdapterFactory();
        ArrayList<ReflectiveItemProviderAdapterFactory> reflectiveFactories = new ArrayList<ReflectiveItemProviderAdapterFactory>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.opencert.apm.assurproj.wizards", EXT_POINT_FACTORIES);
        int i = 0;
        while (i < configs.length) {
            String factoryClass = configs[i].getAttribute(A_FACTORY);
            if (factoryClass != null && factoryClass.trim().length() != 0) {
                try {
                    AdapterFactory factory = (AdapterFactory)configs[i].createExecutableExtension(A_FACTORY);
                    if (factory instanceof ReflectiveItemProviderAdapterFactory) {
                        reflectiveFactories.add((ReflectiveItemProviderAdapterFactory)factory);
                    } else {
                        result.addAdapterFactory(factory);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)e);
                }
            }
            ++i;
        }
        result.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        result.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        for (ReflectiveItemProviderAdapterFactory rFactory : reflectiveFactories) {
            result.addAdapterFactory((AdapterFactory)rFactory);
        }
        result.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return result;
    }
}

