/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.workspace.FolderCDOWorkspaceBase;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.StubCDORevision;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.ecore.EcorePackage;

public class CachingCDOWorkspaceBase
extends FolderCDOWorkspaceBase {
    private static final CDORevision ADDED = new StubCDORevision(EcorePackage.Literals.EOBJECT){

        public String toString() {
            return "ADDED";
        }
    };
    private final Map<CDOID, CDORevision> revisions = new LinkedHashMap<CDOID, CDORevision>();
    private final Map<CDOID, Integer> detachedVersions = new LinkedHashMap<CDOID, Integer>();

    public CachingCDOWorkspaceBase(File folder) {
        super(folder);
    }

    public void init(InternalCDOWorkspace workspace) {
        super.init(workspace);
        for (CDOID id : this.getIDs()) {
            InternalCDORevision revision = this.getRevision(id);
            if (revision == null) {
                revision = ADDED;
            }
            this.revisions.put(id, (CDORevision)revision);
        }
        this.handleAddedAndDetachedObjects(new FolderCDOWorkspaceBase.AddedAndDetachedHandler(){

            public void handleAddedAndDetachedHandler(CDOID id, int detachedVersion) {
                CachingCDOWorkspaceBase.this.detachedVersions.put(id, detachedVersion);
            }
        });
    }

    protected void doRegisterChangedOrDetachedObject(InternalCDORevision revision) {
        super.doRegisterChangedOrDetachedObject(revision);
        CDOID id = revision.getID();
        if (this.revisions.containsKey(id)) {
            return;
        }
        this.revisions.put(id, (CDORevision)revision);
    }

    protected void doRegisterAddedAndDetachedObject(InternalCDORevision revision) {
        super.doRegisterAddedAndDetachedObject(revision);
        CDOID id = revision.getID();
        int detachedVersion = revision.getVersion();
        this.detachedVersions.put(id, detachedVersion);
    }

    protected void doRegisterAddedObject(CDOID id) {
        super.doRegisterAddedObject(id);
        this.revisions.put(id, ADDED);
    }

    protected void doDeregisterObject(CDOID id) {
        super.doDeregisterObject(id);
        this.revisions.remove(id);
    }

    protected void doClear() {
        super.doClear();
        this.revisions.clear();
        this.detachedVersions.clear();
    }
}

