/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.Activator;
import org.eclipse.papyrus.uml.service.types.utils.ClassifierUtils;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class AssociationEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected Classifier getSourceOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Classifier getTargetOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Property createSourceProperty(Type targetType) {
        Property sourceProperty = UMLFactory.eINSTANCE.createProperty();
        sourceProperty.setType(targetType);
        if (targetType.getName() != null) {
            sourceProperty.setName(targetType.getName().toLowerCase());
        }
        return sourceProperty;
    }

    protected Property createTargetProperty(Type sourceType) {
        Property targetProperty = UMLFactory.eINSTANCE.createProperty();
        targetProperty.setType(sourceType);
        if (sourceType.getName() != null) {
            targetProperty.setName(sourceType.getName().toLowerCase());
        }
        return targetProperty;
    }

    protected void addSourceInModel(Property sourceEnd, Classifier owner, Classifier targetType, Association association) throws UnsupportedOperationException {
        boolean added = ClassifierUtils.addOwnedAttribute(owner, sourceEnd);
        if (!added) {
            association.getOwnedEnds().add((Object)sourceEnd);
        }
    }

    protected void addTargetInModel(Property targetEnd, Classifier owner, Classifier sourceType, Association association) {
        boolean added = ClassifierUtils.addOwnedAttribute(owner, targetEnd);
        if (!added) {
            association.getOwnedEnds().add((Object)targetEnd);
        }
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Association association = (Association)request.getElementToConfigure();
        final Classifier sourceType = this.getSourceOwnerType(request);
        final Classifier targetType = this.getTargetOwnerType(request);
        if (sourceType == null || targetType == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ElementUtil.addNature((Element)association, "UML_Nature");
                Property sourceEnd = AssociationEditHelperAdvice.this.createSourceProperty((Type)targetType);
                Property targetEnd = AssociationEditHelperAdvice.this.createTargetProperty((Type)sourceType);
                association.getMemberEnds().add((Object)sourceEnd);
                association.getMemberEnds().add((Object)targetEnd);
                try {
                    AssociationEditHelperAdvice.this.addSourceInModel(sourceEnd, sourceType, targetType, association);
                    AssociationEditHelperAdvice.this.addTargetInModel(targetEnd, targetType, sourceType, association);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return CommandResult.newCancelledCommandResult();
                }
                targetEnd.setOwningAssociation(association);
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest req) {
        ArrayList<Property> dependentsToDestroy = new ArrayList<Property>();
        List dependentsToKeep = req.getParameter("DEPENDENTS_TO_KEEP") != null ? (List)req.getParameter("DEPENDENTS_TO_KEEP") : new ArrayList();
        Association association = (Association)req.getElementToDestroy();
        for (Property end : association.getMemberEnds()) {
            if (dependentsToKeep.contains(end)) continue;
            dependentsToDestroy.add(end);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return req.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return super.getBeforeDestroyDependentsCommand(req);
    }

    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        ICommand gmfCommand = super.getBeforeDestroyReferenceCommand(request);
        Association association = (Association)request.getContainer();
        if (request.getContainingFeature() == UMLPackage.eINSTANCE.getAssociation_MemberEnd() && association.getMemberEnds().contains((Object)request.getReferencedObject())) {
            HashSet ends = new HashSet();
            ends.addAll(association.getMemberEnds());
            ends.remove(request.getReferencedObject());
            if (ends.size() <= 2) {
                DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)association, false);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)association);
                if (provider != null) {
                    ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyCommand);
                }
            }
        }
        return gmfCommand;
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        List<Association> currentlyRefactoredElements;
        ICommand gmfCommand = super.getBeforeReorientRelationshipCommand(request);
        MoveRequest moveRequest = null;
        SetRequest setTypeRequest = null;
        Association association = (Association)request.getRelationship();
        Property changeContainer = null;
        Property changeType = this.getMemberEnd(association, (Classifier)request.getOldRelationshipEnd());
        List list = currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
        if (currentlyRefactoredElements.contains(association)) {
            return null;
        }
        currentlyRefactoredElements.add(association);
        request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
        if (2 == association.getMemberEnds().size()) {
            Property semanticSource = (Property)association.getMemberEnds().get(0);
            Property semanticTarget = (Property)association.getMemberEnds().get(1);
            if (semanticSource.getType().equals(semanticTarget.getType())) {
                if (request.getDirection() == 1) {
                    changeType = semanticTarget;
                }
                if (request.getDirection() == 2) {
                    changeType = semanticSource;
                }
            }
            changeContainer = semanticSource;
            if (changeType.equals(semanticSource)) {
                changeContainer = semanticTarget;
            }
            if (!association.getOwnedEnds().contains((Object)changeContainer)) {
                moveRequest = new MoveRequest(request.getNewRelationshipEnd(), (EObject)changeContainer);
            }
            setTypeRequest = new SetRequest((EObject)changeType, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)request.getNewRelationshipEnd());
            if (moveRequest != null) {
                moveRequest.addParameters(request.getParameters());
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)request.getNewRelationshipEnd());
                if (provider != null) {
                    ICommand moveCommand = provider.getEditCommand((IEditCommandRequest)moveRequest);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)moveCommand);
                }
            }
            if (gmfCommand != null) {
                gmfCommand.reduce();
            }
        } else {
            if (request.getDirection() == 1) {
                return UnexecutableCommand.INSTANCE;
            }
            changeType = this.getMemberEnd(association, (Classifier)request.getOldRelationshipEnd());
            if (changeType != null) {
                setTypeRequest = new SetRequest((EObject)changeType, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)request.getNewRelationshipEnd());
            }
        }
        if (setTypeRequest != null) {
            setTypeRequest.addParameters(request.getParameters());
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)changeType);
            if (provider != null) {
                ICommand setTypeCommand = provider.getEditCommand((IEditCommandRequest)setTypeRequest);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)setTypeCommand);
            }
        }
        return gmfCommand;
    }

    protected Property getMemberEnd(Association association, Classifier classifier) {
        for (Property member : association.getMemberEnds()) {
            if (!member.getType().equals(classifier)) continue;
            return member;
        }
        return null;
    }
}

