/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.wizards.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.polarsys.chess.wizards.wizards.CreateCHESSModelWizard;
import org.polarsys.chess.wizards.wizards.InitModelWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceNewModelStorageProvider {
    private CreateCHESSModelWizard wizard;
    private NewModelFilePage newModelFilePage;

    public boolean canHandle(IStructuredSelection initialSelection) {
        boolean result = false;
        for (Object next : initialSelection.toList()) {
            if (WizardsHelper.adapt(next, IResource.class) == null) continue;
            result = true;
            break;
        }
        return result;
    }

    public void init(CreateCHESSModelWizard wizard, IStructuredSelection selection) {
        this.wizard = wizard;
        this.newModelFilePage = this.createNewModelFilePage(selection);
    }

    public List<? extends IWizardPage> createPages() {
        if (this.newModelFilePage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.newModelFilePage);
    }

    public IStatus validateDiagramCategories(String ... newCategories) {
        if (this.newModelFilePage != null) {
            String firstCategory;
            String string = firstCategory = newCategories.length > 0 ? newCategories[0] : null;
            if (newCategories.length > 0) {
                return this.newModelFilePage.diagramExtensionChanged(this.wizard.getDiagramFileExtension(firstCategory));
            }
        }
        return Status.OK_STATUS;
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard()) {
            return null;
        }
        URI selectedResourceURI = WizardsHelper.getSelectedResourceURI((IStructuredSelection)selection);
        if (this.isCreateFromExistingDomainModel() && selectedResourceURI != null) {
            return new InitModelWizard.NewDiagramForExistingModelPage(selection, this.wizard.getModelKindName(), String.valueOf(this.getDiagramFileName(selectedResourceURI)) + "." + this.wizard.getDiagramFileExtension(null), this.wizard.getDiagramFileExtension(null));
        }
        return new NewModelFilePage(selection, this.wizard.getModelKindName());
    }

    protected String getDiagramFileName(URI domainModelURI) {
        return domainModelURI.trimFileExtension().lastSegment();
    }

    protected boolean isCreateFromExistingDomainModel() {
        return false;
    }

    public URI createNewModelURI(String categoryId) {
        IFile newFile = this.newModelFilePage.createNewFile();
        return newFile == null ? null : URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
    }

    public IEditorInput createEditorInput(URI uri) {
        if (uri.isPlatformResource()) {
            return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
        }
        return new URIEditorInput(uri);
    }
}

