/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;

public class TreeLayer
extends AbstractRowHideShowLayer {
    private static final Log log = LogFactory.getLog(TreeLayer.class);
    public static final String TREE_COLUMN_CELL = "TREE_COLUMN_CELL";
    public static final int TREE_COLUMN_NUMBER = 0;
    private boolean useTreeColumnIndex = false;
    private final ITreeRowModel<?> treeRowModel;
    private final Set<Integer> hiddenRowIndexes = new TreeSet<Integer>();
    private IndentedTreeImagePainter indentedTreeImagePainter;

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter());
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter) {
        this(underlyingLayer, treeRowModel, indentedTreeImagePainter, true);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter(), useDefaultConfiguration);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.treeRowModel = treeRowModel;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultTreeLayerConfiguration(this));
        }
        this.indentedTreeImagePainter = indentedTreeImagePainter;
        this.registerCommandHandler(new TreeExpandCollapseCommandHandler(this));
        this.registerCommandHandler(new TreeCollapseAllCommandHandler(this));
        this.registerCommandHandler(new TreeExpandAllCommandHandler(this));
        this.registerCommandHandler(new TreeExpandToLevelCommandHandler(this));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.isTreeColumn(columnPosition)) {
            configLabels.addLabelOnTop(TREE_COLUMN_CELL);
            int rowIndex = this.getRowIndexByPosition(rowPosition);
            configLabels.addLabelOnTop("TREE_DEPTH_" + this.treeRowModel.depth(rowIndex));
            if (!this.treeRowModel.hasChildren(rowIndex)) {
                configLabels.addLabelOnTop("TREE_LEAF");
            } else if (this.treeRowModel.isCollapsed(rowIndex)) {
                configLabels.addLabelOnTop("TREE_COLLAPSED");
            } else {
                configLabels.addLabelOnTop("TREE_EXPANDED");
            }
        }
        return configLabels;
    }

    public ITreeRowModel<?> getModel() {
        return this.treeRowModel;
    }

    @Deprecated
    public IndentedTreeImagePainter getIndentedTreeImagePainter() {
        return this.indentedTreeImagePainter;
    }

    @Deprecated
    public ICellPainter getTreeImagePainter() {
        return this.indentedTreeImagePainter != null ? this.indentedTreeImagePainter.getTreeImagePainter() : null;
    }

    private boolean isTreeColumn(int columnPosition) {
        if (this.useTreeColumnIndex) {
            return this.getColumnIndexByPosition(columnPosition) == 0;
        }
        return columnPosition == 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        block3: {
            block4: {
                block5: {
                    cellPainter = super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
                    if (!cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL")) break block3;
                    treeCellPainter = configRegistry.getConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
                    if (treeCellPainter == null) break block4;
                    innerWrapper = treeCellPainter;
                    treePainter = null;
                    if (!(innerWrapper instanceof IndentedTreeImagePainter)) ** GOTO lbl12
                    treePainter = (IndentedTreeImagePainter)innerWrapper;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        if (!((innerWrapper = ((CellPainterWrapper)innerWrapper).getWrappedPainter()) instanceof IndentedTreeImagePainter)) continue;
                        treePainter = (IndentedTreeImagePainter)innerWrapper;
lbl12:
                        // 3 sources

                        ** while (treePainter == null && innerWrapper != null && innerWrapper instanceof CellPainterWrapper && ((CellPainterWrapper)innerWrapper).getWrappedPainter() != null)
                    }
                }
                if (treePainter != null) {
                    treePainter.setBaseCellPainter(cellPainter);
                    cellPainter = treeCellPainter;
                } else {
                    TreeLayer.log.warn((Object)"There is no IndentedTreeImagePainter found for TREE_STRUCTURE_PAINTER, using local configured IndentedTreeImagePainter as fallback");
                    this.indentedTreeImagePainter.setBaseCellPainter(cellPainter);
                    cellPainter = new BackgroundPainter(this.indentedTreeImagePainter);
                }
                break block3;
            }
            this.indentedTreeImagePainter.setBaseCellPainter(cellPainter);
            cellPainter = new BackgroundPainter(this.indentedTreeImagePainter);
        }
        return cellPainter;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex) || this.isHiddenInUnderlyingLayer(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return this.hiddenRowIndexes;
    }

    public void expandOrCollapseIndex(int parentIndex) {
        if (this.treeRowModel.isCollapsed(parentIndex)) {
            this.expandTreeRow(parentIndex);
        } else {
            this.collapseTreeRow(parentIndex);
        }
    }

    public void collapseTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.collapse(parentIndex);
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        for (Integer rowIndex : rowIndexes) {
            int rowPos = this.getRowPositionByIndex(rowIndex);
            if (rowPos < 0) continue;
            rowPositions.add(rowPos);
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions));
    }

    public void collapseAll() {
        List<Integer> rowIndexes = this.treeRowModel.collapseAll();
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        for (Integer rowIndex : rowIndexes) {
            int rowPos = this.getRowPositionByIndex(rowIndex);
            if (rowPos < 0) continue;
            rowPositions.add(rowPos);
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions));
    }

    public void expandTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.expand(parentIndex);
        for (Integer expandedChildRowIndex : rowIndexes) {
            this.hiddenRowIndexes.remove(expandedChildRowIndex);
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }

    public void expandTreeRowToLevel(int parentIndex, int level) {
        List<Integer> rowIndexes = this.treeRowModel.expandToLevel(parentIndex, level);
        for (Integer expandedChildRowIndex : rowIndexes) {
            this.hiddenRowIndexes.remove(expandedChildRowIndex);
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }

    public void expandAll() {
        List<Integer> rowIndexes = this.treeRowModel.expandAll();
        this.hiddenRowIndexes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }

    public void expandAllToLevel(int level) {
        List<Integer> rowIndexes = this.treeRowModel.expandToLevel(level);
        for (Integer expandedChildRowIndex : rowIndexes) {
            this.hiddenRowIndexes.remove(expandedChildRowIndex);
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }

    private boolean isHiddenInUnderlyingLayer(int rowIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowHideCommand) {
            return this.handleRowHideCommand((RowHideCommand)command);
        }
        if (command instanceof MultiRowHideCommand) {
            return this.handleMultiRowHideCommand((MultiRowHideCommand)command);
        }
        return super.doCommand(command);
    }

    protected boolean handleRowHideCommand(RowHideCommand command) {
        int rowIndex;
        if (command.convertToTargetLayer(this) && this.treeRowModel.hasChildren(rowIndex = this.getRowIndexByPosition(command.getRowPosition())) && !this.treeRowModel.isCollapsed(rowIndex)) {
            List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
            int[] childPositions = new int[childIndexes.size() + 1];
            childPositions[0] = command.getRowPosition();
            int i = 1;
            while (i < childIndexes.size() + 1) {
                int childPos;
                childPositions[i] = childPos = this.getRowPositionByIndex(childIndexes.get(i - 1));
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }

    protected boolean handleMultiRowHideCommand(MultiRowHideCommand command) {
        if (command.convertToTargetLayer(this)) {
            ArrayList<Integer> rowPositionsToHide = new ArrayList<Integer>();
            for (Integer rowPos : command.getRowPositions()) {
                rowPositionsToHide.add(rowPos);
                int rowIndex = this.getRowIndexByPosition(rowPos);
                if (!this.treeRowModel.hasChildren(rowIndex) || this.treeRowModel.isCollapsed(rowIndex)) continue;
                List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
                for (Integer childIndex : childIndexes) {
                    rowPositionsToHide.add(this.getRowPositionByIndex(childIndex));
                }
            }
            int[] childPositions = new int[rowPositionsToHide.size()];
            int i = 0;
            while (i < rowPositionsToHide.size()) {
                childPositions[i] = (Integer)rowPositionsToHide.get(i);
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }

    public boolean isUseTreeColumnIndex() {
        return this.useTreeColumnIndex;
    }

    public void setUseTreeColumnIndex(boolean useTreeColumnIndex) {
        this.useTreeColumnIndex = useTreeColumnIndex;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add(TREE_COLUMN_CELL);
        result.add("TREE_LEAF");
        result.add("TREE_COLLAPSED");
        result.add("TREE_EXPANDED");
        result.add("TREE_DEPTH_0");
        result.add("TREE_DEPTH_1");
        result.add("TREE_DEPTH_2");
        result.add("TREE_DEPTH_3");
        result.add("TREE_DEPTH_4");
        return result;
    }
}

