/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ContextualDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class MarkupDisplayConverter
extends ContextualDisplayConverter {
    protected IDisplayConverter wrappedConverter;
    protected Map<String, MarkupValue> markups = new HashMap<String, MarkupValue>();

    public MarkupDisplayConverter() {
        this((IDisplayConverter)new DefaultDisplayConverter());
    }

    public MarkupDisplayConverter(IDisplayConverter wrappedConverter) {
        this.wrappedConverter = wrappedConverter;
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        Object wrappedConverterResult = this.wrappedConverter.canonicalToDisplayValue(cell, configRegistry, canonicalValue);
        String result = null;
        if (wrappedConverterResult != null) {
            result = wrappedConverterResult.toString();
            for (MarkupValue markup : this.markups.values()) {
                result = result.replace(markup.originalValue, markup.markupValue);
            }
        }
        return result;
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        if (displayValue != null) {
            String result = displayValue.toString();
            for (MarkupValue markup : this.markups.values()) {
                result = result.replace(markup.markupValue, markup.originalValue);
            }
            return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, (Object)result);
        }
        return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, displayValue);
    }

    public void registerMarkup(String value, String markupPrefix, String markupSuffix) {
        MarkupValue markup = new MarkupValue();
        markup.originalValue = value;
        markup.markupValue = String.valueOf(markupPrefix) + value + markupSuffix;
        this.markups.put(value, markup);
    }

    public void unregisterMarkup(String value) {
        this.markups.remove(value);
    }

    public void clearMarkups() {
        this.markups.clear();
    }

    protected class MarkupValue {
        String originalValue;
        String markupValue;

        protected MarkupValue() {
        }
    }
}

