/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

@Deprecated
public class NewJavaProjectWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPage";
    private WizardNewProjectCreationPage fMainPage;
    private IPath fOutputLocation;
    private IClasspathEntry[] fClasspathEntries;
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fProjectModified;

    public NewJavaProjectWizardPage(IWorkspaceRoot root, WizardNewProjectCreationPage mainpage) {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewJavaProjectWizardPage_title);
        this.setDescription(NewWizardMessages.NewJavaProjectWizardPage_description);
        this.fMainPage = mainpage;
        IStatusChangeListener listener = new IStatusChangeListener(){

            @Override
            public void statusChanged(IStatus status) {
                NewJavaProjectWizardPage.this.updateStatus(status);
            }
        };
        this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), listener, 0, false, null);
        this.fProjectModified = true;
        this.fOutputLocation = null;
        this.fClasspathEntries = null;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            if (this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.dispose();
                this.fBuildPathsBlock = null;
            }
        }
    }

    public void setDefaultOutputFolder(IPath path) {
        this.fOutputLocation = path;
        this.setProjectModified();
    }

    public void setDefaultClassPath(IClasspathEntry[] entries, boolean appendDefaultJRE) {
        if (entries != null && appendDefaultJRE) {
            IClasspathEntry[] jreEntry = NewJavaProjectPreferencePage.getDefaultJRELibrary();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + jreEntry.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            System.arraycopy(jreEntry, 0, newEntries, entries.length, jreEntry.length);
            entries = newEntries;
        }
        this.fClasspathEntries = entries;
        this.setProjectModified();
    }

    public void setProjectModified() {
        this.fProjectModified = true;
    }

    protected IProject getProjectHandle() {
        Assert.isNotNull((Object)this.fMainPage);
        return this.fMainPage.getProjectHandle();
    }

    protected IPath getLocationPath() {
        Assert.isNotNull((Object)this.fMainPage);
        return this.fMainPage.getLocationPath();
    }

    public IJavaProject getNewJavaProject() {
        return JavaCore.create((IProject)this.getProjectHandle());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.fBuildPathsBlock.createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        this.setControl((Control)composite);
    }

    protected void initBuildPaths() {
        this.fBuildPathsBlock.init(this.getNewJavaProject(), this.fOutputLocation, this.fClasspathEntries);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && (this.fProjectModified || this.isNewProjectHandle())) {
            this.initBuildPaths();
            this.fProjectModified = false;
        }
    }

    private boolean isNewProjectHandle() {
        IProject oldProject = this.fBuildPathsBlock.getJavaProject().getProject();
        return !oldProject.equals((Object)this.getProjectHandle());
    }

    public IPath getOutputLocation() {
        return this.fBuildPathsBlock.getOutputLocation();
    }

    public IClasspathEntry[] getRawClassPath() {
        return this.fBuildPathsBlock.getRawClassPath();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.NewJavaProjectWizardPage_op_desc, 10);
                if (NewJavaProjectWizardPage.this.fProjectModified || NewJavaProjectWizardPage.this.isNewProjectHandle()) {
                    NewJavaProjectWizardPage.this.initBuildPaths();
                }
                try {
                    try {
                        IPath locationPath = NewJavaProjectWizardPage.this.getLocationPath();
                        BuildPathsBlock.createProject(NewJavaProjectWizardPage.this.getProjectHandle(), locationPath != null ? URIUtil.toURI((IPath)locationPath) : null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        BuildPathsBlock.addJavaNature(NewJavaProjectWizardPage.this.getProjectHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        NewJavaProjectWizardPage.this.fBuildPathsBlock.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 6));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }
}

