/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;

public class DefaultClasspathFixProcessor
extends ClasspathFixProcessor {
    @Override
    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String missingType) throws CoreException {
        ArrayList<DefaultClasspathFixProposal> res = new ArrayList<DefaultClasspathFixProposal>();
        this.collectProposals(project, missingType, res);
        return res.toArray(new ClasspathFixProcessor.ClasspathFixProposal[res.size()]);
    }

    private void collectProposals(IJavaProject project, String name, Collection<DefaultClasspathFixProposal> proposals) throws CoreException {
        int idx = name.lastIndexOf(46);
        char[] packageName = idx != -1 ? name.substring(0, idx).toCharArray() : null;
        char[] typeName = name.substring(idx + 1).toCharArray();
        if (typeName.length == 1 && typeName[0] == '*') {
            typeName = null;
        }
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList<TypeNameMatch> res = new ArrayList<TypeNameMatch>();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(res);
        int matchMode = 8;
        new SearchEngine().searchAllTypeNames(packageName, matchMode, typeName, matchMode, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
        if (res.isEmpty()) {
            return;
        }
        HashSet<Object> addedClaspaths = new HashSet<Object>();
        int i = 0;
        while (i < res.size()) {
            block13: {
                TypeNameMatch curr = res.get(i);
                IType type = curr.getType();
                if (type != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
                    try {
                        IClasspathEntry newEntry;
                        Change change;
                        IClasspathEntry entry = root.getRawClasspathEntry();
                        if (entry == null) break block13;
                        IJavaProject other = root.getJavaProject();
                        int entryKind = entry.getEntryKind();
                        if ((entry.isExported() || entryKind == 3) && addedClaspaths.add(other) && (change = ClasspathFixProcessor.ClasspathFixProposal.newAddClasspathChange(project, newEntry = JavaCore.newProjectEntry((IPath)other.getPath()))) != null) {
                            String label;
                            Object[] args = new String[]{BasicElementLabels.getResourceName(other.getElementName()), BasicElementLabels.getResourceName(project.getElementName())};
                            String desc = label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_project_description, args);
                            DefaultClasspathFixProposal proposal = new DefaultClasspathFixProposal(label, change, desc, 8);
                            proposals.add(proposal);
                        }
                        if (entryKind == 5) {
                            IPath entryPath = entry.getPath();
                            if (this.isNonProjectSpecificContainer(entryPath)) {
                                this.addLibraryProposal(project, root, entry, addedClaspaths, proposals);
                                break block13;
                            }
                            try {
                                IClasspathEntry entryInContainer;
                                IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)entryPath, (IJavaProject)root.getJavaProject());
                                if (classpathContainer != null && (entryInContainer = JavaModelUtil.findEntryInContainer(classpathContainer, root.getPath())) != null) {
                                    this.addLibraryProposal(project, root, entryInContainer, addedClaspaths, proposals);
                                }
                                break block13;
                            }
                            catch (CoreException coreException) {}
                            break block13;
                        }
                        if (entryKind == 1 || entryKind == 4) {
                            this.addLibraryProposal(project, root, entry, addedClaspaths, proposals);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            ++i;
        }
    }

    private void addLibraryProposal(IJavaProject project, IPackageFragmentRoot root, IClasspathEntry entry, Collection<Object> addedClaspaths, Collection<DefaultClasspathFixProposal> proposals) throws JavaModelException {
        Change change;
        String label;
        if (addedClaspaths.add(entry) && (label = DefaultClasspathFixProcessor.getAddClasspathLabel(entry, root, project)) != null && (change = ClasspathFixProcessor.ClasspathFixProposal.newAddClasspathChange(project, entry)) != null) {
            DefaultClasspathFixProposal proposal = new DefaultClasspathFixProposal(label, change, label, 7);
            proposals.add(proposal);
        }
    }

    private boolean isNonProjectSpecificContainer(IPath containerPath) {
        String id;
        return containerPath.segmentCount() > 0 && ((id = containerPath.segment(0)).equals("org.eclipse.jdt.USER_LIBRARY") || id.equals(JavaRuntime.JRE_CONTAINER));
    }

    private static String getAddClasspathLabel(IClasspathEntry entry, IPackageFragmentRoot root, IJavaProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                if (root.isArchive()) {
                    Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0x200000000000L), BasicElementLabels.getJavaElementName(project.getElementName())};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_archive_description, args);
                }
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0x200000000000L), BasicElementLabels.getJavaElementName(project.getElementName())};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_classfolder_description, args);
            }
            case 4: {
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0L), BasicElementLabels.getJavaElementName(project.getElementName())};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_variable_description, args);
            }
            case 5: {
                try {
                    Object[] args = new String[]{JavaElementLabels.getContainerEntryLabel(entry.getPath(), root.getJavaProject()), BasicElementLabels.getJavaElementName(project.getElementName())};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_library_description, args);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return null;
    }

    private static class DefaultClasspathFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private String fName;
        private Change fChange;
        private String fDescription;
        private int fRelevance;

        public DefaultClasspathFixProposal(String name, Change change, String description, int relevance) {
            this.fName = name;
            this.fChange = change;
            this.fDescription = description;
            this.fRelevance = relevance;
        }

        @Override
        public String getAdditionalProposalInfo() {
            return this.fDescription;
        }

        @Override
        public Change createChange(IProgressMonitor monitor) {
            return this.fChange;
        }

        @Override
        public String getDisplayString() {
            return this.fName;
        }

        @Override
        public Image getImage() {
            return JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        }

        @Override
        public int getRelevance() {
            return this.fRelevance;
        }
    }
}

