/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.extensions;

import org.eclipse.papyrus.marte.vsl.vSL.AdditiveExpression;
import org.eclipse.papyrus.marte.vsl.vSL.AndOrXorExpression;
import org.eclipse.papyrus.marte.vsl.vSL.CollectionOrTuple;
import org.eclipse.papyrus.marte.vsl.vSL.ConditionalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.DataTypeName;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsName;
import org.eclipse.papyrus.marte.vsl.vSL.EqualityExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsName;
import org.eclipse.papyrus.marte.vsl.vSL.Interval;
import org.eclipse.papyrus.marte.vsl.vSL.JitterExp;
import org.eclipse.papyrus.marte.vsl.vSL.ListOfValueNamePairs;
import org.eclipse.papyrus.marte.vsl.vSL.ListOfValues;
import org.eclipse.papyrus.marte.vsl.vSL.Literal;
import org.eclipse.papyrus.marte.vsl.vSL.MultiplicativeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.NameOrChoiceOrBehaviorCall;
import org.eclipse.papyrus.marte.vsl.vSL.OperationCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PrimaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PropertyCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.QualifiedName;
import org.eclipse.papyrus.marte.vsl.vSL.RelationalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.StringLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.SuffixExpression;
import org.eclipse.papyrus.marte.vsl.vSL.TimeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Tuple;
import org.eclipse.papyrus.marte.vsl.vSL.UnaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.ValueNamePair;
import org.eclipse.papyrus.marte.vsl.vSL.ValueSpecification;
import org.eclipse.papyrus.marte.vsl.vSL.VariableDeclaration;

public class VSLSerializationUtil {
    public static String printExpression(Expression exp) {
        return VSLSerializationUtil.printAndOrXorExpression(exp.getExp());
    }

    public static String printAndOrXorExpression(AndOrXorExpression exp) {
        String stringRep = VSLSerializationUtil.printEqualityExpression((EqualityExpression)exp.getExp().get(0));
        int i = 1;
        while (i < exp.getExp().size()) {
            stringRep = String.valueOf(stringRep) + " " + (String)exp.getOp().get(i - 1) + " " + VSLSerializationUtil.printEqualityExpression((EqualityExpression)exp.getExp().get(i));
            ++i;
        }
        return stringRep;
    }

    public static String printEqualityExpression(EqualityExpression exp) {
        String stringRep = VSLSerializationUtil.printRelationalExpression((RelationalExpression)exp.getExp().get(0));
        int i = 1;
        while (i < exp.getExp().size()) {
            stringRep = String.valueOf(stringRep) + " " + (String)exp.getOp().get(i - 1) + " " + VSLSerializationUtil.printRelationalExpression((RelationalExpression)exp.getExp().get(i));
            ++i;
        }
        return stringRep;
    }

    public static String printRelationalExpression(RelationalExpression exp) {
        String stringRep = VSLSerializationUtil.printConditionalExpression((ConditionalExpression)exp.getExp().get(0));
        int i = 1;
        while (i < exp.getExp().size()) {
            stringRep = String.valueOf(stringRep) + " " + (String)exp.getOp().get(i - 1) + " " + VSLSerializationUtil.printConditionalExpression((ConditionalExpression)exp.getExp().get(i));
            ++i;
        }
        return stringRep;
    }

    public static String printConditionalExpression(ConditionalExpression exp) {
        String stringRep = VSLSerializationUtil.printAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
        if (exp.getExp().size() == 3) {
            stringRep = String.valueOf(stringRep) + " ? " + VSLSerializationUtil.printAdditiveExpression((AdditiveExpression)exp.getExp().get(1)) + " : " + VSLSerializationUtil.printAdditiveExpression((AdditiveExpression)exp.getExp().get(2));
        }
        return stringRep;
    }

    public static String printAdditiveExpression(AdditiveExpression exp) {
        String stringRep = VSLSerializationUtil.printMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
        int i = 1;
        while (i < exp.getExp().size()) {
            stringRep = String.valueOf(stringRep) + " " + (String)exp.getOp().get(i - 1) + " " + VSLSerializationUtil.printMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(i));
            ++i;
        }
        return stringRep;
    }

    public static String printMultiplicativeExpression(MultiplicativeExpression exp) {
        String stringRep = VSLSerializationUtil.printUnaryExpression((UnaryExpression)exp.getExp().get(0));
        int i = 1;
        while (i < exp.getExp().size()) {
            stringRep = String.valueOf(stringRep) + " " + (String)exp.getOp().get(i - 1) + " " + VSLSerializationUtil.printUnaryExpression((UnaryExpression)exp.getExp().get(i));
            ++i;
        }
        return stringRep;
    }

    public static String printUnaryExpression(UnaryExpression exp) {
        String stringRep = "";
        stringRep = exp.getUnary() != null ? String.valueOf(stringRep) + exp.getOp() + " " + VSLSerializationUtil.printUnaryExpression(exp.getUnary()) : String.valueOf(stringRep) + VSLSerializationUtil.printPrimaryExpression(exp.getExp());
        return stringRep;
    }

    public static String printPrimaryExpression(PrimaryExpression exp) {
        String stringRep = VSLSerializationUtil.printValueSpecification(exp.getPrefix());
        if (exp.getSuffix() != null) {
            stringRep = String.valueOf(stringRep) + "." + VSLSerializationUtil.printSuffixExpression(exp.getSuffix());
        }
        return stringRep;
    }

    public static String printSuffixExpression(SuffixExpression suffix) {
        if (suffix instanceof PropertyCallExpression) {
            return VSLSerializationUtil.printPropertyCallExpression((PropertyCallExpression)suffix);
        }
        return VSLSerializationUtil.printOperationCallExpression((OperationCallExpression)suffix);
    }

    public static String printOperationCallExpression(OperationCallExpression suffix) {
        String stringRep = suffix.getOperation().getName() + "(";
        if (suffix.getArguments() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printListOfValues(suffix.getArguments());
        }
        stringRep = String.valueOf(stringRep) + ")";
        if (suffix.getSuffix() != null) {
            stringRep = String.valueOf(stringRep) + "." + VSLSerializationUtil.printSuffixExpression(suffix.getSuffix());
        }
        return stringRep;
    }

    public static String printPropertyCallExpression(PropertyCallExpression suffix) {
        String stringRep = suffix.getProperty().getName();
        if (suffix.getSuffix() != null) {
            stringRep = String.valueOf(stringRep) + "." + VSLSerializationUtil.printSuffixExpression(suffix.getSuffix());
        }
        return stringRep;
    }

    public static String printValueSpecification(ValueSpecification exp) {
        if (exp instanceof StringLiteralRule) {
            return "\"" + ((Literal)exp).getValue() + "\"";
        }
        if (exp instanceof Literal) {
            return ((Literal)exp).getValue();
        }
        if (exp instanceof NameOrChoiceOrBehaviorCall) {
            return VSLSerializationUtil.printNameOrChoiceOrBehaviorCall((NameOrChoiceOrBehaviorCall)exp);
        }
        if (exp instanceof Interval) {
            return VSLSerializationUtil.printInterval((Interval)exp);
        }
        if (exp instanceof CollectionOrTuple) {
            return VSLSerializationUtil.printCollectionOrTuple((CollectionOrTuple)exp);
        }
        if (exp instanceof Tuple) {
            return VSLSerializationUtil.printTuple((Tuple)exp);
        }
        if (exp instanceof TimeExpression) {
            return VSLSerializationUtil.printTimeExpression((TimeExpression)exp);
        }
        if (exp instanceof VariableDeclaration) {
            return VSLSerializationUtil.printVariableDeclaration((VariableDeclaration)exp);
        }
        if (exp instanceof Expression) {
            return "(" + VSLSerializationUtil.printExpression((Expression)exp) + ")";
        }
        return "";
    }

    public static String printVariableDeclaration(VariableDeclaration exp) {
        String stringRep = "";
        if (exp.getVariableDeclaration() != null && !exp.getVariableDeclaration().equals("")) {
            stringRep = String.valueOf(stringRep) + exp.getVariableDeclaration() + " ";
        }
        stringRep = String.valueOf(stringRep) + "$" + exp.getName();
        if (exp.getType() != null) {
            stringRep = String.valueOf(stringRep) + " : " + VSLSerializationUtil.printDataTypeName(exp.getType());
        }
        if (exp.getInitValue() != null) {
            stringRep = String.valueOf(stringRep) + " = (" + VSLSerializationUtil.printExpression(exp.getInitValue()) + ")";
        }
        return stringRep;
    }

    public static String printDataTypeName(DataTypeName type) {
        String stringRep = "";
        if (type.getPath() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printQualifiedName(type.getPath());
        }
        stringRep = String.valueOf(stringRep) + type.getType().getName();
        return stringRep;
    }

    public static String printTimeExpression(TimeExpression exp) {
        if (exp instanceof InstantObsExpression) {
            return VSLSerializationUtil.printInstantObsExpression((InstantObsExpression)exp);
        }
        if (exp instanceof DurationObsExpression) {
            return VSLSerializationUtil.printDurationObsExpression((DurationObsExpression)exp);
        }
        return VSLSerializationUtil.printJitterExp((JitterExp)exp);
    }

    public static String printJitterExp(JitterExp exp) {
        String stringRep = "jitter(";
        stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printInstantObsExpression(exp.getFirstInstant());
        if (exp.getSecondInstant() != null) {
            stringRep = String.valueOf(stringRep) + " - " + VSLSerializationUtil.printInstantObsExpression(exp.getSecondInstant());
        }
        stringRep = String.valueOf(stringRep) + ")";
        return stringRep;
    }

    public static String printInstantObsExpression(InstantObsExpression exp) {
        String stringRep = "@" + VSLSerializationUtil.printInstantObsName(exp.getId());
        if (exp.getIndex() != null) {
            stringRep = String.valueOf(stringRep) + "(" + VSLSerializationUtil.printExpression(exp.getIndex()) + ")";
        }
        if (exp.getCondition() != null) {
            stringRep = String.valueOf(stringRep) + " when (" + VSLSerializationUtil.printExpression(exp.getCondition()) + ")";
        }
        return stringRep;
    }

    public static String printInstantObsName(InstantObsName id) {
        String stringRep = "";
        if (id.getPath() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printQualifiedName(id.getPath());
        }
        stringRep = String.valueOf(stringRep) + id.getInstantId().getName();
        return stringRep;
    }

    public static String printDurationObsExpression(DurationObsExpression exp) {
        String stringRep = "&" + VSLSerializationUtil.printDurationObsName(exp.getId());
        if (exp.getIndex() != null) {
            stringRep = String.valueOf(stringRep) + "(" + VSLSerializationUtil.printExpression(exp.getIndex()) + ")";
        }
        if (exp.getCondition() != null) {
            stringRep = String.valueOf(stringRep) + " when (" + VSLSerializationUtil.printExpression(exp.getCondition()) + ")";
        }
        return stringRep;
    }

    public static String printDurationObsName(DurationObsName id) {
        String stringRep = "";
        if (id.getPath() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printQualifiedName(id.getPath());
        }
        stringRep = String.valueOf(stringRep) + id.getDurationId().getName();
        return stringRep;
    }

    public static String printTuple(Tuple exp) {
        String stringRep = "{";
        stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printListOfValueNamePairs(exp.getListOfValueNamePairs());
        stringRep = String.valueOf(stringRep) + "}";
        return stringRep;
    }

    public static String printListOfValueNamePairs(ListOfValueNamePairs listOfValueNamePairs) {
        String stringRep = "";
        boolean first = true;
        for (ValueNamePair exp : listOfValueNamePairs.getValueNamePairs()) {
            if (first) {
                first = false;
            } else {
                stringRep = String.valueOf(stringRep) + ", ";
            }
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printValueNamePair(exp);
        }
        return stringRep;
    }

    public static String printValueNamePair(ValueNamePair exp) {
        String stringRep = "";
        stringRep = String.valueOf(stringRep) + exp.getProperty().getName() + " = " + VSLSerializationUtil.printExpression(exp.getValue());
        return stringRep;
    }

    public static String printCollectionOrTuple(CollectionOrTuple exp) {
        String stringRep = "{";
        stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printListOfValues(exp.getListOfValues());
        stringRep = String.valueOf(stringRep) + "}";
        return stringRep;
    }

    public static String printInterval(Interval exp) {
        String stringRep = "";
        stringRep = String.valueOf(stringRep) + (exp.getIsLowerIncluded() != null && !exp.getIsLowerIncluded().equals("") ? "[" : "]");
        stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printExpression(exp.getLower());
        stringRep = String.valueOf(stringRep) + " .. ";
        stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printExpression(exp.getUpper());
        stringRep = String.valueOf(stringRep) + (exp.getIsUpperIncluded() != null && !exp.getIsUpperIncluded().equals("") ? "]" : "[");
        return stringRep;
    }

    public static String printNameOrChoiceOrBehaviorCall(NameOrChoiceOrBehaviorCall exp) {
        String stringRep = "";
        if (exp.getPath() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printQualifiedName(exp.getPath());
        }
        stringRep = String.valueOf(stringRep) + exp.getId().getName();
        if (exp.getArguments() != null) {
            stringRep = String.valueOf(stringRep) + "(" + VSLSerializationUtil.printListOfValues(exp.getArguments()) + ")";
        }
        return stringRep;
    }

    public static String printListOfValues(ListOfValues arguments) {
        String stringRep = "";
        boolean first = true;
        for (Expression exp : arguments.getValues()) {
            if (first) {
                first = false;
            } else {
                stringRep = String.valueOf(stringRep) + ", ";
            }
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printExpression(exp);
        }
        return stringRep;
    }

    public static String printQualifiedName(QualifiedName exp) {
        String stringRep = String.valueOf(exp.getPath().getName()) + "::";
        if (exp.getRemaining() != null) {
            stringRep = String.valueOf(stringRep) + VSLSerializationUtil.printQualifiedName(exp.getRemaining());
        }
        return stringRep;
    }

    public static NameOrChoiceOrBehaviorCall extractNameReference(Expression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall(exp.getExp());
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(AndOrXorExpression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall((EqualityExpression)exp.getExp().get(0));
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(EqualityExpression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall((RelationalExpression)exp.getExp().get(0));
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(RelationalExpression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall((ConditionalExpression)exp.getExp().get(0));
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(ConditionalExpression exp) {
        if (exp.getExp().size() == 1) {
            return VSLSerializationUtil.isANameOrBehaviorCall((AdditiveExpression)exp.getExp().get(0));
        }
        if (exp.getExp().size() == 3) {
            NameOrChoiceOrBehaviorCall coll = VSLSerializationUtil.isANameOrBehaviorCall((AdditiveExpression)exp.getExp().get(1));
            return coll != null ? VSLSerializationUtil.isANameOrBehaviorCall((AdditiveExpression)exp.getExp().get(2)) : null;
        }
        return null;
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(AdditiveExpression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall((MultiplicativeExpression)exp.getExp().get(0));
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(MultiplicativeExpression exp) {
        return exp.getExp().isEmpty() ? null : VSLSerializationUtil.isANameOrBehaviorCall((UnaryExpression)exp.getExp().get(0));
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(UnaryExpression exp) {
        return VSLSerializationUtil.isANameOrBehaviorCall(exp.getExp());
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(PrimaryExpression exp) {
        return exp.getSuffix() == null ? VSLSerializationUtil.isANameOrBehaviorCall(exp.getPrefix()) : null;
    }

    private static NameOrChoiceOrBehaviorCall isANameOrBehaviorCall(ValueSpecification exp) {
        return exp instanceof NameOrChoiceOrBehaviorCall ? (NameOrChoiceOrBehaviorCall)exp : null;
    }
}

