/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.matchers.stereotype;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationMatcher
implements IElementMatcher {
    private List<String> stereotypesQualifiedNames;
    private String profileUri;

    public StereotypeApplicationMatcher(StereotypeApplicationMatcherConfiguration configuration) {
        this.profileUri = configuration.getProfileUri();
        this.stereotypesQualifiedNames = configuration.getStereotypesQualifiedNames();
    }

    public boolean matches(EObject eObject) {
        if (!(eObject instanceof Element)) {
            return false;
        }
        Element element = (Element)eObject;
        if (element.getAppliedStereotypes().isEmpty()) {
            return false;
        }
        for (String stereotypeQualifiedName : this.stereotypesQualifiedNames) {
            if (element.getAppliedStereotype(stereotypeQualifiedName) != null) continue;
            return false;
        }
        if (this.profileUri != null) {
            Model model = element.getModel();
            if (model == null) {
                return false;
            }
            ArrayList<String> appliedProfileByUri = new ArrayList<String>();
            for (Profile appliedProfile : model.getAllAppliedProfiles()) {
                appliedProfileByUri.add(appliedProfile.getURI());
            }
            if (!appliedProfileByUri.contains(this.profileUri)) {
                return false;
            }
        }
        return true;
    }

    public List<String> getStereotypesQualifiedNames() {
        return this.stereotypesQualifiedNames;
    }

    public void setStereotypesQualifiedNames(List<String> stereotypeQualifiedName) {
        this.stereotypesQualifiedNames = stereotypeQualifiedName;
    }
}

