/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.newchild;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.newchild.CreationMenuFactory;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreationMenu;
import org.eclipse.papyrus.infra.widgets.util.RevealResultCommand;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.papyrus.views.modelexplorer.newchild.Activator;
import org.eclipse.papyrus.views.modelexplorer.newchild.commands.EditResultCommand;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ModelExplorerMenuFactory
extends CreationMenuFactory {
    private boolean defaultSelectionPreference = Activator.getDefault().getPreferenceStore().getBoolean("defaultSelection");
    private boolean defaultEditionPreference = Activator.getDefault().getPreferenceStore().getBoolean("defaultEdition");
    private IViewPart viewPart = this.getActiveViewPart();

    public ModelExplorerMenuFactory(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    protected Command buildCommand(EReference reference, EObject container, CreationMenu creationMenu, Map<?, ?> advice) {
        Command buildCommand = super.buildCommand(reference, container, creationMenu, advice);
        if (buildCommand == null || buildCommand == UnexecutableCommand.INSTANCE) {
            return buildCommand;
        }
        if (this.defaultSelectionPreference) {
            buildCommand = RevealResultCommand.wrap((Command)buildCommand, (IViewPart)this.viewPart, (EObject)container);
            if (this.defaultEditionPreference && this.viewPart instanceof ModelExplorerView) {
                buildCommand = EditResultCommand.wrap(buildCommand, this.viewPart);
            }
        }
        return buildCommand;
    }

    private IViewPart getActiveViewPart() {
        IViewPart activeView = null;
        IViewPart modelExplorerView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
        if (modelExplorerView instanceof MultiViewPageBookView) {
            MultiViewPageBookView pageBook = (MultiViewPageBookView)modelExplorerView;
            activeView = pageBook.getActiveView();
        }
        return activeView;
    }
}

