/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.model;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.ocl.pivot.internal.context.EInvocationContext;
import org.eclipse.ocl.pivot.internal.context.EObjectContext;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.xtext.base.attributes.RootCSAttribution;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.ui.model.ConsoleContext;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class BaseDocument
extends XtextDocument
implements ConsoleContext {
    private @Nullable EObject context;
    private @Nullable Map<String, EClassifier> parameters;

    @Inject
    public BaseDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
    }

    protected void checkForErrors(Resource resource) throws CoreException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            StringBuilder s = new StringBuilder();
            for (Resource.Diagnostic diagnostic : errors) {
                s.append("\n");
                if (diagnostic instanceof XtextSyntaxDiagnostic) {
                    s.append("Syntax error: ");
                    String location = diagnostic.getLocation();
                    if (location != null) {
                        s.append(location);
                        s.append(":");
                    }
                    s.append(diagnostic.getLine());
                    s.append(" ");
                    s.append(diagnostic.getMessage());
                    continue;
                }
                s.append(diagnostic.toString());
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", s.toString()));
        }
    }

    public @Nullable ASResource getASResource() throws CoreException {
        return (ASResource)this.readOnly((IUnitOfWork)new IUnitOfWork<ASResource, XtextResource>(){

            public ASResource exec(@Nullable XtextResource resource) throws Exception {
                if (!(resource instanceof BaseCSResource)) {
                    return null;
                }
                BaseCSResource csResource = (BaseCSResource)resource;
                CS2AS cs2as = csResource.findCS2AS();
                if (cs2as == null) {
                    return null;
                }
                ASResource asResource = cs2as.getASResource();
                BaseDocument.this.checkForErrors((Resource)asResource);
                return asResource;
            }
        });
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            super.fireDocumentChanged(event);
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            super.fireDocumentAboutToBeChanged(event);
        }
    }

    protected RootCSAttribution getDocumentAttribution() {
        return (RootCSAttribution)this.readOnly((IUnitOfWork)new IUnitOfWork<RootCSAttribution, XtextResource>(){

            public RootCSAttribution exec(@Nullable XtextResource resource) throws Exception {
                ElementCS csElement;
                if (resource != null && !resource.getContents().isEmpty() && (csElement = (ElementCS)resource.getContents().get(0)) != null) {
                    Attribution attribution = PivotUtilInternal.getAttribution((EObject)csElement);
                    return ElementUtil.getDocumentAttribution((ElementCS)csElement);
                }
                return null;
            }
        });
    }

    @Override
    public @Nullable EObject getOCLContext() {
        return this.context;
    }

    @Override
    public @Nullable Map<String, EClassifier> getOCLParameters() {
        return this.parameters;
    }

    public @Nullable ResourceSet getResourceSet() {
        return (ResourceSet)this.readOnly((IUnitOfWork)new IUnitOfWork<ResourceSet, XtextResource>(){

            public ResourceSet exec(@Nullable XtextResource resource) throws Exception {
                return resource != null ? resource.getResourceSet() : null;
            }
        });
    }

    public void saveAsPivot(@NonNull StringWriter writer) throws CoreException, IOException {
        ASResource asResource = this.getASResource();
        if (asResource != null) {
            asResource.save((Writer)writer, null);
        }
    }

    @Override
    public void setContext(final @NonNull EClassifier ecoreContext, final @Nullable Map<String, EClassifier> ecoreParameters) {
        this.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(@Nullable XtextResource resource) throws Exception {
                if (resource instanceof BaseCSResource) {
                    BaseCSResource csResource = (BaseCSResource)resource;
                    csResource.setParserContext((ParserContext)new EInvocationContext(csResource.getEnvironmentFactory(), resource.getURI(), ecoreContext, ecoreParameters));
                }
                return null;
            }
        });
        this.context = ecoreContext;
        this.parameters = ecoreParameters;
    }

    public @Nullable Object setContext(@NonNull BaseCSResource csResource, @Nullable EObject eObject) {
        csResource.setParserContext((ParserContext)new EObjectContext(csResource.getEnvironmentFactory(), csResource.getURI(), eObject));
        return null;
    }
}

